package gov.va.med.mhv.common.data.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;

@Component
public class InPersonAuthenticationConverter {
	
	@Autowired
	private PatientConverter patientConverter; 

	@Autowired
	private UserProfileConverter userProfileConverter; 
	
	public InPersonAuthenticationDTO convertDomainInpersonAuthentication(InPersonAuthentication ipa) {
		InPersonAuthenticationDTO ipaDTO = new InPersonAuthenticationDTO();
		
		ipaDTO.setApprovedForRecordsAccess(ipa.getApprovedForRecordsAccess());
		ipaDTO.setAuthenticatedBy(ipa.getAuthenticatedBy());
		ipaDTO.setAuthenticationDate(ipa.getAuthenticationDate());
		ipaDTO.setDefermentReason(ipa.getDefermentReason());
		ipaDTO.setId(ipa.getId());
		ipaDTO.setIdentificationPresented(ipa.getIdentificationPresented());
		ipaDTO.setMviAuthenticationStatus(ipa.getMviAuthenticationStatus());
		ipaDTO.setOplock(ipa.getOplock());
		ipaDTO.setParticipationFormSigned(ipa.getParticipationFormSigned());
		ipaDTO.setRemovalReason(ipa.getRemovalReason());
		ipaDTO.setSignedFormOnlineDateTime(ipa.getSignedFormOnlineDateTime());
		ipaDTO.setStartUpgradeManualDateTime(ipa.getStartUpgradeOnlineDateTime());
		ipaDTO.setStartUpgradeOnlineDateTime(ipa.getStartUpgradeOnlineDateTime());
		ipaDTO.setStatus(ipa.getStatus());
		ipaDTO.setVideoViewed(ipa.getVideoViewed());
		return ipaDTO;
	}
	
	public void addPatientDto(InPersonAuthentication ipa, InPersonAuthenticationDTO ipaDTO) {
		if (null != ipa && null != ipaDTO && null != ipa.getPatient()) {
			ipaDTO.setPatient(patientConverter.convertDomainPatient(ipa.getPatient()));
		}
	}
	
	

	public InPersonAuthentication convertInpersonAuthenticationDTO(InPersonAuthenticationDTO ipaDto) {
		InPersonAuthentication ipa = new InPersonAuthentication();
		
		ipa.setApprovedForRecordsAccess(ipaDto.getApprovedForRecordsAccess());
		ipa.setAuthenticatedBy(ipaDto.getAuthenticatedBy());
		ipa.setAuthenticationDate(ipaDto.getAuthenticationDate());
		ipa.setDefermentReason(ipaDto.getDefermentReason());
		ipa.setId(ipaDto.getId());
		ipa.setIdentificationPresented(ipaDto.getIdentificationPresented());
		ipa.setMviAuthenticationStatus(ipaDto.getMviAuthenticationStatus());
		ipa.setOplock(ipaDto.getOplock());
		ipa.setParticipationFormSigned(ipaDto.getParticipationFormSigned());
		ipa.setRemovalReason(ipaDto.getRemovalReason());
		ipa.setSignedFormOnlineDateTime(ipaDto.getSignedFormOnlineDateTime());
		ipa.setStartUpgradeManualDateTime(ipaDto.getStartUpgradeOnlineDateTime());
		ipa.setStartUpgradeOnlineDateTime(ipaDto.getStartUpgradeOnlineDateTime());
		ipa.setStatus(ipaDto.getStatus());
		ipa.setVideoViewed(ipaDto.getVideoViewed());
		
		if (null != ipaDto.getPatient()) {
			ipa.setPatient(patientConverter.convertDTOProfile(ipaDto.getPatient()));
		}
				
		return ipa;
	}
	
	public void addPatientProfile(InPersonAuthenticationDTO ipaDTO, InPersonAuthentication ipa) {
		if (null != ipaDTO && null != ipa && null != ipaDTO.getPatient()) {
			ipa.setPatient(patientConverter.convertDTOProfile(ipaDTO.getPatient()));
		}
	}
}