package gov.va.med.mhv.core.crypto;

import java.io.IOException;
import java.io.OutputStream;

import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class MHVCipherOutputStream extends CipherOutputStream {
	private long byteCount = 0;
	
	public MHVCipherOutputStream(OutputStream os, Cipher c) {
		super(os, c);
	}
	
	@Override
	public void close() throws IOException {
		super.close();
	}

	@Override
	public void flush() throws IOException {
		super.flush();
	}

	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		super.write(b, off, len);
		byteCount+=len;
	}

	@Override
	public void write(byte[] b) throws IOException {
		super.write(b);
		byteCount+=b.length;
	}

	@Override
	public void write(int b) throws IOException {
		super.write(b);
		byteCount+=1;
	}

	public long getByteCount() {
		return byteCount;
	}

	public void setByteCount(long byteCount) {
		this.byteCount = byteCount;
	}
	
}

