package gov.va.med.mhv.common.essapi.interceptor;

import gov.va.med.mhv.common.essapi.cache.CacheHandler;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * 
 *  RECEIVE
 *  (PRE/USER/POST)_STREAM
 *  READ
 *  (PRE/USER/POST)_PROTOCOL
 *  UNMARSHAL
 *  (PRE/USER/POST)_LOGICAL
 *  PRE_INVOKE
 *  INVOKE
 *  POST_INVOKE 
 */
public class RequestInterceptor extends AbstractPhaseInterceptor<Message> {
	private Log log = LogFactory.getLog(RequestInterceptor.class);
	
	public RequestInterceptor() {
		super(Phase.RECEIVE);
	}

	public void handleMessage(Message message) {
//		System.out.println("message.getDestination(): " +message.getDestination().getAddress());
//		System.out.println("message.toString(): " +message.toString());
//		System.out.println("MESSAGE-2: " +message.get(Message.PROTOCOL_HEADERS));
//		System.out.println("MESSAGE-3: " +message.get(Message.REQUEST_URI));
		
		 
		if( log.isInfoEnabled() ) {
		//	log.info("[Thread " + Thread.currentThread().getId() + "] LogInInterceptor  " );
		//	log.info("Request URI:  " + message.get(Message.REQUEST_URI)
		//				+ "::" + "Header Info:  " + message.get(Message.PROTOCOL_HEADERS));
		}
		CacheHandler.resetInstance();
		CacheHandler.getInstance().setInboundMessage(message);
		
	}

	public void handleFault(Message message) {
		String method = String.valueOf(message.get(Message.HTTP_REQUEST_METHOD));
		String request = String.valueOf(message.get(Message.REQUEST_URI));
		if( log.isInfoEnabled() ) {
			log.info("[Thread " + Thread.currentThread().getId() + "] INBOUND " + message.getId() + " " + method + " " + request);
		}
		CacheHandler.resetInstance();
		CacheHandler.getInstance().setInboundMessage(message);
		
	}
}
