package gov.va.med.mhv.common.api.util;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVErrorEnumeration;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.ClientApplication;
import gov.va.med.mhv.common.api.transfer.ErrorTO;
import gov.va.med.mhv.common.api.transfer.Session;

import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Response.ResponseBuilder;

import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@PreMatching
public class SessionAuthCheckFilter implements ContainerRequestFilter {

	@Context
	org.apache.cxf.jaxrs.ext.MessageContext mc;

	private static final String TOKEN_HEADER_KEY = "Token";

	private UriInfo uriInfo;
	private boolean internalService = false;

	@Override
	public void filter(ContainerRequestContext context) throws IOException {
		Message m = JAXRSUtils.getCurrentMessage();
		
		Session session = null;
		String token = null;
		
        try {
        	HttpHeaders headers = new HttpHeadersImpl(m);
        	MultivaluedMap<String, String> hMap = headers.getRequestHeaders();

//        	//Add-Merge in the cookies that don't exist in headers
//        	for(String key : headers.getCookies().keySet()) {
//        		if(!hMap.containsKey(key)) {
//        			hMap.add(key, headers.getCookies().get(key).getValue());
//        		}
//        	}
        	boolean header = hMap.containsKey(TOKEN_HEADER_KEY);
        	boolean cookie = headers.getCookies().containsKey(TOKEN_HEADER_KEY);
        	
        	if (!header && !cookie) 
        	{
    			throw new MHVException(ErrorEnum.MISSING_SESSION_TOKEN_108.getErrorMessage());
        	} 
        	else {
        		
        		if( header ) {
        			token = MHVApiUtility.getValueOfHeaderElement(headers, TOKEN_HEADER_KEY);
        			session = MHVApiUtility.decrypt(token);
        			
        		} else if( cookie ) {
        			token = headers.getCookies().get(TOKEN_HEADER_KEY).getValue();
        			session = MHVApiUtility.decrypt(token);
        		}
        		
				if(session == null) {
					throw new MHVException(ErrorEnum.INVALID_SESSION_TOKEN_109.getErrorMessage());
				}	
				
				// TODO: Is session still valid.
				if (session.isExpired()) {
					throw new MHVException(ErrorEnum.EXPIRED_SESSION_TOKEN_110.getErrorMessage());
				}
				
				internalService = session.getClientApplication().isInternal();
        	}
        	//it will be disabled once API Management Tool is in active 
        	if(session.getClientApplication().getUriPathCheck()) {
	        	if(!internalService) {
	        		uriInfo = context.getUriInfo();
	        		executeAdditonalChecksforExt(session.getClientApplication());
	        	}	
        	}
        	
        	//MAKE THE SESSION AVAILABLE FOR ALL SERVICES 
        	CacheHandler.getInstance().setSession(session);
        	CacheHandler.getInstance().setToken(token);
        	
        } catch (AuthenticationException ex) {
            context.abortWith(handleAuthenticationException(ex));
        } catch (MHVException ex) {
            context.abortWith(handleAuthenticationException(ex));
        } catch (Exception e) {
        	context.abortWith(handleAuthenticationException(new MHVException(e)));
		}
	
	}
	
	protected Response handleAuthenticationException(MHVException ex) {
		if(internalService) {
			ResponseBuilder builder = Response.status(Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON);
			MHVException mhvEx = new MHVException();
			mhvEx.setErrorCode(MHVErrorEnumeration.ERROR);
			mhvEx.setFailureMessage(ex.getMessage());
	        return builder.entity(mhvEx).build();
		}
		else {
			ResponseBuilder builder = Response.status(Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON);
			ErrorTO error = new ErrorTO();
			StringBuffer sb = new StringBuffer();
			sb.append("Error:"+ex.getFailureMessage()+";");
			error.setDeveloperMessage(sb.toString());
			return builder.entity(error).build();
		}
    }
	
	protected Response handleAuthenticationException(SecurityException ex) {
		return Response.ok(ex, MediaType.APPLICATION_JSON).status(Response.Status.BAD_REQUEST).build();
    }
	
	protected void executeAdditonalChecksforExt(ClientApplication clientApplication) throws MHVException{
		//Check Application Authorization
		if( !checkClientAuthorizationPermissions( clientApplication) ) {
			throw new MHVException(ErrorEnum.APPLICATION_AUTHORIZATION_FAILED_102.getErrorMessage());
		}

	}
	
	private boolean checkClientAuthorizationPermissions( ClientApplication client) {
		String path = uriInfo.getRequestUri().getPath();
		for( String permission: client.getAuthorizations()) {
			if(path.contains(permission)) {
				return true;
			}
		}
		return false;
	}
    
}
