package gov.va.med.mhv.common.api.util;


import java.util.LinkedHashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;

import gov.va.med.mhv.common.api.exception.MHVException;

@XmlRootElement(name = "Response")
public class ResponseUtil<T> {

	private boolean success;
	private boolean failure;
	private String failureMessage;
	private String successMessage;
	private T pojoObject;
	private LinkedHashMap<String, String> validationErrors;
	private LinkedHashMap<String, String> infoMessages;

	public ResponseUtil() {
	}

	public ResponseUtil(T pojo) {
		pojoObject = pojo;
	}
	
	public ResponseUtil(boolean success, boolean failure,
			String failureMessage, String successMessage, T pojoObject,
			LinkedHashMap<String, String> validationErrors,
			LinkedHashMap<String, String> infoMessages) {
		super();
		this.success = success;
		this.failure = failure;
		this.failureMessage = failureMessage;
		this.successMessage = successMessage;
		this.pojoObject = pojoObject;
		this.validationErrors = validationErrors;
		this.infoMessages = infoMessages;
	}
	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public boolean isFailure() {
		return failure;
	}

	public void setFailure(boolean failure) {
		this.failure = failure;
	}

	public String getFailureMessage() {
		return failureMessage;
	}

	public void setFailureMessage(String failureMessage) {
		this.failureMessage = failureMessage;
	}

	public String getSuccessMessage() {
		return successMessage;
	}

	public void setSuccessMessage(String successMessage) {
		this.successMessage = successMessage;
	}

	public T getPojoObject() {
		return pojoObject;
	}

	public void setPojoObject(T pojoObject) {
		this.pojoObject = pojoObject;
	}

	public LinkedHashMap<String, String> getValidationErrors() {
		return validationErrors;
	}

	public void setValidationErrors(LinkedHashMap<String, String> validationErrors) {
		this.validationErrors = validationErrors;
	}

	public LinkedHashMap<String, String> getInfoMessages() {
		if (null == this.infoMessages) {
			this.infoMessages = new LinkedHashMap<String, String>();
		}
		return infoMessages;
	}

	public void setInfoMessages(LinkedHashMap<String, String> infoMessages) {
		this.infoMessages = infoMessages;
	}
	
	public static ResponseUtil<MHVException> toResponseUtil(MHVException ex) {
		ResponseUtil<MHVException> response = new ResponseUtil<MHVException>();
		response.setFailure(true);
		response.setFailureMessage(ex.getFailureMessage());
		response.setInfoMessages(mapToLinkedHashMap(ex.getInfoMessages()));
		response.setValidationErrors(mapToLinkedHashMap(ex.getValidationErrorMessages()));
		
		return response;
	}
	
	public static LinkedHashMap<String, String> mapToLinkedHashMap(Map<String, String> src) {
		LinkedHashMap<String, String> dest = new LinkedHashMap<String, String>();
		
		if(src != null && src.keySet().size() > 0) {
			for(String key : src.keySet()) {
				dest.put(key, src.get(key));
			}
		}
		
		return dest;
	}
}

