package gov.va.med.mhv.common.api.util;


import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesHelper {
	private static final Log log = LogFactory.getLog(PropertiesHelper.class);
	private static String PROPERTIES_FILE_NAME; 
	private static Properties properties;

	static {
		loadProperties();
	}

	public static String getFileName() {
		return PROPERTIES_FILE_NAME;
	}
	
	private static void loadProperties() {
		String env = System.getProperty("MHV_ENV_PROPERTY", "local");
		PROPERTIES_FILE_NAME =  env + "." + "mhv-api.properties"; 
		Properties props = ConfigurationManager.getConfiguration(PROPERTIES_FILE_NAME);
		
		if (props != null) {
			properties = props;
		} 
		else {
			log.error("An error occurred while loading properties file.");
		}
	}

	public static Properties getProperties() {
		if(properties !=null)
			return properties;
		else {
			loadProperties();
			return properties;
		}
	}

}