package gov.va.med.mhv.common.api.util;

import java.io.IOException;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;

import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@PreMatching
public class MHVAuthKeyCheckFilter implements ContainerRequestFilter {

	@Context
	org.apache.cxf.jaxrs.ext.MessageContext mc;
	
    private final static String KEY="X-Authorization-Key";
    private final static String VAL="E8ECD-5F9D713DA-BC6CCF12D-ACAA-48";

	@Override
	public void filter(ContainerRequestContext context) throws IOException {
		Message m = JAXRSUtils.getCurrentMessage();
		HttpHeaders headers = new HttpHeadersImpl(m);
		String token = MHVApiUtility.getValueOfHeaderElement(headers, KEY);
    	
    	if(token==null || ! token.equals(VAL) ) {
    		throw new IOException("Invalid token");
    	}
	}
    
}
