package gov.va.med.mhv.common.api.util;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.spec.KeySpec;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.HttpHeaders;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.springframework.batch.core.JobExecution;
import org.springframework.util.Base64Utils;

import gov.va.med.mhv.common.api.transfer.Session;

public class MHVApiUtility {

	private static final Log log = LogFactory.getLog(MHVApiUtility.class);
	
	public static String SECRETKEY_ALGO="PBKDF2WithHmacSHA1";
	public static String CIPHER_PADDING="PBEWithMD5AndTripleDES";

	public static String SALT_VALUE_KEY="salt.value";
	public static String GENERAL_VALUE_KEY="general.key";

	public static String RFC1123_PATTERN  =	"EEE, dd MMM yyyy HH:mm:ss z";

	private static SecretKey secret;
	private static byte[] ciphertext = null;
	private static byte[] salt = null;
	
	public static String getValueOfHeaderElement(HttpHeaders headers, String elementKey) {
		String elementValue = headers.getHeaderString(elementKey);
		return elementValue;
	}

	static {
		
		SecretKeyFactory keyFac;

		Properties p = PropertiesHelper.getProperties();

        String saltValue = p.getProperty(SALT_VALUE_KEY);
        salt = saltValue.getBytes();
		
		try {
	        // Create PBE parameter set
	        String generalKey = p.getProperty(GENERAL_VALUE_KEY);
	        keyFac = SecretKeyFactory.getInstance(SECRETKEY_ALGO);
	        KeySpec spec = new PBEKeySpec(generalKey.toCharArray(), salt, 65536, 128);
	        SecretKey tmp = keyFac.generateSecret(spec);
	        secret = new SecretKeySpec(tmp.getEncoded(), "AES");
		} catch(Exception e) {
			log.error("exception occurred" + e);
		}
		
	}
	
	public static String encrypt(Session session) throws Exception {

		try {
	        // Our cleartext
	        byte[] cleartext = session.marshall();

	        Cipher cipher = Cipher.getInstance("AES");
	        cipher.init(Cipher.ENCRYPT_MODE, secret);
	        ciphertext = cipher.doFinal(cleartext);
		
		} catch (Exception eX) {
			log.error("exception occurred" + eX);
			throw new Exception("Unable to create session token",eX);
		}

		String saltString = Base64Utils.encodeToString(salt);
		String ciphertextString = Base64Utils.encodeToString(ciphertext);

		return saltString+ciphertextString;
	}

	public static Session decrypt(String ciphertext) throws Exception {
		Session session = null;

    	// Begin by splitting the text into salt and text Strings
		// salt is first 12 chars, BASE64 encoded from 8 bytes.
		String ciphertext2 = ciphertext.substring(12,ciphertext.length());

		// BASE64Decode the bytes for the salt and the ciphertext
		byte[] ciphertextArray = Base64Utils.decodeFromString(ciphertext2);
		byte[] clearText1 = null;
        try {
	        Cipher cipher = Cipher.getInstance("AES");
	        cipher.init(Cipher.DECRYPT_MODE, secret);
	        clearText1 = cipher.doFinal(ciphertextArray);
        }
        catch (Exception eX) {
        	log.error("exception occurred" + eX);
        }
        session = Session.unmarshall(clearText1);
		return session;
	}

	public static String encode(Session session) {
		byte res[] = null;
		try {
			res = session.marshall();
		} catch (IOException e) {
			log.error("exception occurred" + e);
		}
		return Base64.encodeBase64String(res);
	}
	
	public static Session decode (String res) {
		byte[] res1 = Base64.decodeBase64 (res.getBytes());
		Session session = null;
		try {
			session = Session.unmarshall(res1);
		} catch (ClassNotFoundException | IOException e) {
			log.error("exception occurred" + e);
		}
		return session;
	}

	
	public static boolean isMhvAuthenticationEnabled() {

		Properties p = PropertiesHelper.getProperties();
		Boolean isMhvAuthEnable =
			(p != null) ? Boolean.parseBoolean(p.getProperty("mhv.user.authentication.enabled")) : false;
			
		return 	isMhvAuthEnable;
	}

	/*
	public static void throwExceptionOnErrors(ErrorEnum errorEnum, org.tigris.atlas.service.ServiceResponse response) throws WebApplicationException {
		if( response.getMessages().getErrorMessageCount() > 0 ) {
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);

			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			Collection msgs = response.getMessages().getErrorMessages();
			Iterator iterator = msgs.iterator();
			while(iterator.hasNext()) {
				Message message = (Message)iterator.next();
        		sb.append(message.getSeverity()+":"+message.getKey()+";");
			}

			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);

			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}

	public static void throwExceptionOnErrors(ErrorEnum errorEnum, CollectionServiceResponse response) throws WebApplicationException {
		if( response.getMessages().getErrorMessageCount() > 0 ) {
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);

			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			Collection<Message> msgs = (Collection<Message>)response.getMessages().getErrorMessages();
			for(Message message: msgs) {
				sb.append(message.getSeverity()+":"+message.getKey()+";");
			}
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);

			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
		}
	}
	*/
	
	/*public static void throwExceptionOnErrors(ErrorEnum errorEnum, ResponseUtil response) throws WebApplicationException {
		
			ResponseBuilderImpl builder = new ResponseBuilderImpl();
			builder.status(400);

			ErrorTO error = new ErrorTO(errorEnum);
			StringBuffer sb = new StringBuffer();
			sb.append("Error:"+response.getFailureMessage()+";");
			error.setDeveloperMessage(sb.toString());
			CacheHandler.getInstance().setError(error);

			Response responseException = builder.build();
			throw new WebApplicationException(responseException);
	}*/
	
	public static byte[] extractByteArray(final InputStream inputStream) throws IOException {
	    ByteArrayOutputStream buffer = new ByteArrayOutputStream();

	    byte[] dataChunk = new byte[1024 * 16];
	    int numRead = 0;
	    while (numRead != -1) {
	        numRead = inputStream.read(dataChunk, 0, dataChunk.length);

	        if (numRead != -1) {
	            buffer.write(dataChunk, 0, numRead);
	        }
	    }

	    buffer.flush();
	    return buffer.toByteArray();
	}

	public static String convertDateToMMDDYYYY(Date dt ) {

		DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		 String reportDate = df.format(dt);
		 return reportDate;

	}
	public static String convertDateToRFC1123Pattern(Date dt ) {
		SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_PATTERN);
		String reportDate = formatter.format(dt);
		return reportDate;

	}
	
	public static Date convertRFCPatterntoDate( String dateString) {
		SimpleDateFormat formatter = new SimpleDateFormat(MHVApiUtility.RFC1123_PATTERN);
		Date dt = null;
		try {
			dt = formatter.parse(dateString);
		} catch (ParseException e) {
			log.error("Exception occured in Data Parsing", e);
			return null;
		}
		return dt;
		
	}

	public static Timestamp converRFC1123PatternTimeStamp(String dateString ) {
		SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_PATTERN);
		Date date = null;
		try {
			date = formatter.parse(dateString);
		} catch (ParseException e) {
			log.error("Exception occured in Data Parsing", e);
			return null;
		}
		return new Timestamp(date.getTime());

	}

	public static String constructEmailBody(JobExecution execution) {
		Template t = null;
        StringWriter writer = new StringWriter();
		try {
	        VelocityContext context = new VelocityContext();
	        context.put("jobStatus", execution.getStatus());
	        context.put("startDateTime", execution.getCreateTime());
	        context.put("endDateTime", execution.getEndTime());

			//Initialize the engine
			VelocityEngine ve = new VelocityEngine();
			ve.setProperty(RuntimeConstants.FILE_RESOURCE_LOADER_PATH, System.getProperty("config.location"));
			ve.init();
			//Get the template
			t = ve.getTemplate( "emailTemplates/appt_emailrem_jobstatus_template.vm" );
			t.merge( context, writer );
		} catch (ResourceNotFoundException e) {
			log.error("exception occurred",e);
		} catch (ParseErrorException e) {
			// TODO Auto-generated catch block
			log.error("exception occurred",e);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			log.error("exception occurred",e);
		}
		return writer.toString();
	}
	
//	public static void main(String arg[]) {
//		String a[] = {"/ab"};
//		for(int i=0;i<100;i++) {
//			System.out.println("===="+i+"====");
//			
//			try {
//				String enc = encrypt(new Session(1234, new ClientApplication(1l, "nm", "aja;gl", a, a, 12345)));
//				//Session s = decrypt(enc);
//				
//				System.out.println(enc);
//			} catch (Exception e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//				
//		}
//	}
	
}