package gov.va.med.mhv.common.api.util;


import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationManager {
	
	private static Logger log = LogManager.getLogger(ConfigurationManager.class);

	public static Properties getConfiguration(String propertyFileName) {
		
		InputStream isPropertyFile = null;
		try {
		//	String configFileResource = System.getProperty(propertyFileName);
			Properties config = new Properties();
			isPropertyFile = ConfigurationManager.class.getClassLoader().getResourceAsStream(propertyFileName);
			config.load(isPropertyFile);
			//config.load(ConfigurationManager.class.getResourceAsStream(propertyFileName));
        	if(log.isInfoEnabled()){
	            log.info("loaded properties from " + propertyFileName);
	            log.info(config.toString());
        	}
			
			return config;
		} catch(FileNotFoundException fnfe) {
			log.fatal( "gov.va.med.mhv.util.ConfigurationManager", fnfe );
			log.fatal("CJM - 02062008 - PUT BACK IN");
			//TODO PUT THIS BACK IN ONCE UNIT TESTS ARE REFACTORED TO HANDLE THE FAIL FAST
			//throw new IllegalStateException( "Unable to locate properties file: " + location + propertyFileName );
		} catch(IOException ioe) { 
			log.fatal( "gov.va.med.mhv.util.ConfigurationManager", ioe );
			log.fatal("CJM - 02062008 - PUT BACK IN");
			//TODO PUT THIS BACK IN ONCE UNIT TESTS ARE REFACTORED TO HANDLE THE FAIL FAST
			//throw new IllegalStateException( "Unable to open properties file: " + location + propertyFileName ); 
		} finally {
			if(isPropertyFile != null) {
				try {
					isPropertyFile.close();
				} catch (Exception ex) {
					log.error("Error closing configuration file input stream.", ex);
				}
			}
		}
		return null;
	}	
}
