package gov.va.med.mhv.common.api.util;


import gov.va.med.mhv.common.api.transfer.ClientApplication;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientApplicationHelper {
	private static final Log log = LogFactory.getLog(ClientApplicationHelper.class);
	
	private static Map<Long,ClientApplication> hashById = new Hashtable<Long,ClientApplication>();
	private static Map<String,ClientApplication> hashByToken = new Hashtable<String,ClientApplication>();
	
	static {
		Properties p = PropertiesHelper.getProperties();
		
        String applications = p.getProperty("applications");
		String list[] = applications.split(","); 
        
		for (String app: list) {
			ClientApplication c1 = new ClientApplication(Long.parseLong(p.getProperty(app+".id")),
																			p.getProperty(app+".name"), p.getProperty(app+".token"),
															p.getProperty(app+".permissions").split(","),
															p.getProperty(app+".authorizations").split(","),
															Integer.parseInt(p.getProperty(app+".expiration")),
															Boolean.valueOf(p.getProperty(app+".internal")),
															Boolean.valueOf(p.getProperty("mhv.uri.traffic.auth.check"))		
															);
			hashById.put(c1.getId(), c1);
			hashByToken.put(c1.getAppToken(), c1);
        }
		
		if( hashById.size() == 0 ) {
			throw new RuntimeException("Unable to locate any API Clients in the " + PropertiesHelper.getFileName() + " property file.");
		}
	}
	
	public static ClientApplication findClientApplication(Long id){
		return hashById.get(id);
	}
	
	public static ClientApplication findClientApplication(String token){
		return hashByToken.get(token);
	}
}
