package gov.va.med.mhv.common.api.transfer;

import gov.va.med.mhv.common.api.enumeration.ErrorEnum;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "Error")
public class ErrorTO implements Serializable {
	private static final long serialVersionUID = -41455379983521826L;

	private int errorCode;
	private String errorMessage;
	private String developerMessage;

	public ErrorTO() {
	}

	public ErrorTO(int errorCode, String message, Object developerMessage) {
		this.errorCode = errorCode;
		this.errorMessage = message;
		this.developerMessage = developerMessage.toString();
	}

	public ErrorTO(ErrorEnum error, Object developerMessage) {
		this.errorCode = error.getId();
		this.errorMessage = error.getErrorMessage();
		try {
		this.developerMessage = (developerMessage==null?"":developerMessage.toString());
		} catch(Exception e) {
			//do nothing here.
		}
	}

	public ErrorTO(ErrorEnum error) {
		this.errorCode = error.getId();
		this.errorMessage = error.getErrorMessage();
		this.developerMessage = "";
	}

	public int getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

	public String getMessage() {
		return errorMessage;
	}

	public void setMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getDeveloperMessage() {
		return developerMessage;
	}

	public void setDeveloperMessage(String developerMessage) {
		this.developerMessage = developerMessage;
	}

	public String toString() {
		return "Error {errorCode: " + errorCode +";errorMessage: "+errorMessage +";developerMessage:"+developerMessage +"}";
	}
}
