/**
 * 
 */
package gov.va.med.mhv.common.api.security;

import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.message.Message;

/**
 * @author DNS   egberb
 *
 */
public class TrustedServiceAuthenticationFilter extends ApiAuthenticationFilter {
	
	@Override
	protected void doAuthentication(Message m) throws AuthenticationException, SecurityException {
		
		if(!m.get(Message.REQUEST_URI).toString().contains("/trusted/")) {
			throw new SecurityException("Authorization key mismatch");
		}
		
		super.doAuthentication(m);
	}
}
