package gov.va.med.mhv.common.api.security;

import java.util.Properties;

public class BasicTokenAuthenticationImpl implements BasicTokenAuthentication {
	private Properties properties = new Properties();
	private String requiredKey = null;
	private String requiredHeader = null;
	private final String REQUIRED_KEY_PROP = "auth.value";
	private final String REQUIRED_HEADER_PROP = "auth.header";

	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.api.security.BasicTokenAuthentication#validate(java.lang.String
	 * )
	 */
	public boolean validate(String authenticationTokenValue) {
		if (getRequiredHeader() != null && getRequiredKey() != null
				&& getRequiredKey().equals(authenticationTokenValue)) {
			return true;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.api.security.BasicTokenAuthentication#getRequiredKey()
	 */
	public String getRequiredKey() {
		if (requiredKey == null)
			setRequiredKey(getProperties().getProperty(REQUIRED_KEY_PROP, null));
		return requiredKey;
	}

	private void setRequiredKey(String requiredKey) {
		this.requiredKey = requiredKey;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.api.security.BasicTokenAuthentication#getRequiredHeader()
	 */
	public String getRequiredHeader() {
		if (requiredHeader == null)
			setRequiredHeader(getProperties().getProperty(REQUIRED_HEADER_PROP,
					null));
		return requiredHeader;
	}

	private void setRequiredHeader(String requiredHeader) {
		this.requiredHeader = requiredHeader;
	}

}
