package gov.va.med.mhv.common.api.interceptor;




import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.exception.MHVException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * 
 * RECEIVE (PRE/USER/POST)_STREAM READ (PRE/USER/POST)_PROTOCOL UNMARSHAL
 * (PRE/USER/POST)_LOGICAL PRE_INVOKE INVOKE POST_INVOKE
 */
public class ResponseInterceptor extends AbstractPhaseInterceptor<Message> {
	private Log log = LogFactory.getLog(ResponseInterceptor.class);
	
	public ResponseInterceptor() {
		super(Phase.SEND_ENDING);
	}

	public void handleMessage(Message outboundMessage) {
		if( log.isDebugEnabled()) {
			log.debug("[Thread " + Thread.currentThread().getId() + "] LogOutInterceptor ");
		}
		
		Message inboundMessage = CacheHandler.getInstance().getInboundMessage();
		MHVException error = CacheHandler.getInstance().getError();
		
		if( log.isInfoEnabled()) {
			log.info((error == null ? "SUCCESS" : "ERROR") + ": "
				+ CacheHandler.getInstance().getSession()
				+ "; Request: "
				+ String.valueOf(inboundMessage.get(Message.HTTP_REQUEST_METHOD))
				+ " "
				+ String.valueOf("Request URI:" + inboundMessage.get(Message.REQUEST_URI))
				+ String.valueOf(" Header Info:" + inboundMessage.get(Message.PROTOCOL_HEADERS))
				+ "; Response: "
				+ Integer.parseInt(String.valueOf(outboundMessage.get(Message.RESPONSE_CODE)))
				+ (error != null ? "; Error: " + error : ""));
		}
		
		CacheHandler.resetInstance();
	}

	public void handleFault(Message outboundMessage) {
		CacheHandler.resetInstance();
		//Nothing to do here
	}
	
}
