package gov.va.med.mhv.common.api.exception;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;

@Provider
public class MHVExceptionServiceMapper implements ExceptionMapper<MHVException> {
	
	@Override
	public Response toResponse(MHVException exception) {

		CacheHandler.getInstance().setError(exception);

		if (exception != null)
			return Response.ok(exception, MediaType.APPLICATION_JSON).status(Response.Status.BAD_REQUEST).build();
		else {
			return Response.ok(new MHVException(ErrorEnum.UNKNOWN_99.getErrorMessage()), MediaType.APPLICATION_JSON)
					.status(Response.Status.BAD_REQUEST).build();
		}
	}
}
