package gov.va.med.mhv.common.api.exception;

import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;

public class MHVExceptionClientMapper implements ResponseExceptionMapper<MHVException> {
	
	private static Logger log = LogManager.getLogger(MHVExceptionClientMapper.class);
	
	@Override
	public MHVException fromResponse(Response response) {
		try {
			String jsonStr = response.readEntity(String.class);
			if(log.isDebugEnabled()) {
				log.debug("MHVException JSON String:\n" +
			              "=========================\n" + jsonStr);
			}
			
			ObjectMapper mapper = new ObjectMapper();
			mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
			
			JsonParser parser = new MappingJsonFactory(mapper).createParser(jsonStr);
			return parser.readValueAs(MHVException.class);
		} catch (Exception ex) {
			return new MHVException("Could not deserialize server side exception: " + ex.getMessage());
		}
	}

}