package gov.va.med.mhv.common.api.exception;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlElement;

@XmlRootElement
public class ExceptionDTO implements Serializable {

	private static final long serialVersionUID = -9179885684858019070L;
	private String message;
	private String developerMessage;
	
	public ExceptionDTO(){}
	
	public ExceptionDTO(String message) {
		setMessage(message);
	}
	
	public ExceptionDTO(String message, String developerMessage) {
		setMessage(message);
		setDeveloperMessage(developerMessage);
	}
	
	public void setDeveloperMessage(String developerMessage) {
		this.developerMessage = developerMessage;
	}
	
	public void setMessage(String message) {
		this.message = message;
	}
	
	@XmlElement
	public String getMessage() {
		return this.message;
	}
	
	@XmlElement
	public String getDeveloperMessage() {
		return this.developerMessage;
	}
}
