package gov.va.med.mhv.common.api.exception;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(MediaType.APPLICATION_JSON)
public class ApiExceptionMapper implements ExceptionMapper<Exception> {

	public Response toResponse(Exception e) {
		if (e instanceof ClientErrorException) {
			ExceptionDTO eDTO = new ExceptionDTO("The supplied URL does not exist or was not found.", e.getMessage());
			return Response
					.status(Status.NOT_FOUND)
					.entity(eDTO)
					.type(MediaType.APPLICATION_JSON)
					.build();
		} else {
			ExceptionDTO eDTO = new ExceptionDTO("An error occurred on the server.", e.getMessage());
			return Response
					.status(Status.INTERNAL_SERVER_ERROR)
					.entity(eDTO)
					.type(MediaType.APPLICATION_JSON)
					.build();
		}
	}

}
