package gov.va.med.mhv.common.api.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum InformationSelectionTypeEnum {
	ALL_INFORMATION("ALL_INFORMATION", 1L), CUSTOM("CUSTOM", 4L);

	private String type;
	private Long value;

	private InformationSelectionTypeEnum(String type, Long value) {
		this.type = type;
		this.value = value;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static List<InformationSelectionTypeEnum> toList() {
		return Arrays.asList(InformationSelectionTypeEnum.values());
	}

	public static InformationSelectionTypeEnum valueOfByType(String type) {
		for (InformationSelectionTypeEnum e : InformationSelectionTypeEnum.values()) {
			if (e.getType().equals(type)) {
				return e;
			}
		}
		return null;
	}

	public static List<String> toTypesOfInformationSelectionTypeList() {
		List<String> typeList = new ArrayList<String>();
		for (InformationSelectionTypeEnum ft : Arrays.asList(InformationSelectionTypeEnum.values())) {
			typeList.add(ft.getType());
		}
		return typeList;
	}

	static public boolean isALLINFORMATION(InformationSelectionTypeEnum reportType) {
		return reportType == ALL_INFORMATION;
	}

	static public boolean isCUSTOM(InformationSelectionTypeEnum reportType) {
		return reportType == CUSTOM;
	}

}
