package gov.va.med.mhv.common.api.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum FieldTestEnum {
	BBMI_FIELD_TESTER ("BBMI", "BBMI Field Tester", false), 
	VACCDDIRECT_FIELD_TESTER ("VACCDDIRECT", "VACCDDIRECT Field Tester", false),
	BBGUI_FIELD_TESTER ("BBGUI", "BBGUI Field Tester", false),
	DELEGATE_FIELD_TESTER ("Delegates", "Delegate Field Tester", false);
	
	private String name;
	private String role;
	private Boolean national;
	
	private FieldTestEnum() {
	}
	
	public Boolean getNational() {
		return national;
	}

	/**
	 * Only set this value if you know what you're doing!
	 * @param national
	 */
	@Deprecated
	public void setNational(Boolean national) {
		this.national = national;
	}

	public String getRole() {
		return role;
	}
	
	public String getName() {
		return name;
	}

	private FieldTestEnum(String name, String role, Boolean national){
		this.name = name;
		this.role = role;
		this.national = national;
	}
	
	public static List<FieldTestEnum> toList(){
		return Arrays.asList(FieldTestEnum.values());
	}
	
	public static FieldTestEnum valueOfByRole(String role) {
		for( FieldTestEnum e: FieldTestEnum.values()) {
			if(e.getRole().equals(role)) {
				return e;
			}
		}
		return null;
	}
	
	public static FieldTestEnum valueOfByName(String name) {
		for( FieldTestEnum e: FieldTestEnum.values()) {
			if(e.getName().equals(name)) {
				return e;
			}
		}
		return null;
	}
	
	public static List<String> toRoleList(){
		List<String> roleList = new ArrayList<String>();
		for(FieldTestEnum ft : Arrays.asList(FieldTestEnum.values())) {
			roleList.add(ft.getRole());
		}
		return roleList;
	}
	
	public static List<String> toNameList(){
		List<String> nameList = new ArrayList<String>();
		for(FieldTestEnum ft : Arrays.asList(FieldTestEnum.values())) {
			nameList.add(ft.getName());
		}
		return nameList;
	}
	
}
