package gov.va.med.mhv.calendar.web.controller;


import gov.va.med.mhv.calendar.dto.CalendarEventDTO;
import gov.va.med.mhv.calendar.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.calendar.dto.CategoryDTO;
import gov.va.med.mhv.calendar.dto.MHVEventModel;
import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.calendar.util.CommonUtility;

import gov.va.med.mhv.calendar.util.MHVEventComparator;
import gov.va.med.mhv.calendar.web.util.WebServiceClientUtil;
import gov.va.med.mhv.common.api.dto.ContactDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.mrp.common.dto.MyTaskSearchDTO;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

import javax.annotation.PostConstruct;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.schedule.Schedule;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.DefaultScheduleModel;
import org.primefaces.model.ScheduleModel;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portlet.PortletURLFactoryUtil;

@ManagedBean
@Component
@Scope("session")
public class HealthCalendarController  extends AbstractController{
	
	private static final long serialVersionUID = -7017569448675377128L;
	private MHVEventModel event = new MHVEventModel();
	private MHVEventModel selectedEvent = new MHVEventModel();
	private MHVEventModel newEvent= new MHVEventModel();
    private DefaultScheduleModel eventModel;
    private ScheduleModel lazyEventModel;
    //private String searchEventText;
    private Schedule schedule = new Schedule();
    private String scheduleView;
    private Date scheduleDate;
    private List<ToDoTaskDTO> todos= new ArrayList<ToDoTaskDTO>();
    private ToDoTaskDTO selectedToDo = new ToDoTaskDTO();
    private ToDoTaskDTO newToDO = new ToDoTaskDTO();
    protected int todoRowsPerPage=10;
    protected int eventRowsPerPage=10;
    protected int searchResultsRowsPerPage=10;
	protected ValueExpression todoSortColumn;
	protected String toDosortBy;
	protected ValueExpression eventSortColumn;
	protected String eventsortBy;
	private DataTable todoTable;
	private List<CategoryDTO> calCategories;
	private String[] selectedCategories= new String[50];
	private CalendarSearchCriteriaDTO searchCriteria;
	List<MHVEventModel> events;
	private DataTable eventTable;
	private UserCalViewDTO userPreference;
	Long patientId;
	private String viewType;
	private String previousView;
	private String userPreferView="";
	private List<MHVEventModel> searchResults;
	private Date selectDate;
	
	private Date minCurrentYear;
	private Date maxCurrentYear;
	private Date minNextYear;
	private Date maxNextYear;
	private String minCalDate;
	private String maxCalDate;
	private Integer searchResultNumber;
	private String lastupdatedDate;
	
	private String filterTodo;
	private Date exportStartDate;
	private Date exportEndDate;
	private String[] exportSelectedCategories= new String[50];
	private List<CategoryDTO> exportCalCateories;
	private Date exportMinYear;
	private Date exportMaxYear;
	private boolean exportValidationError;
	private String view;
	private String lastViewType="";
	private String lastUserPreferView="";
	
	private UserProfileDTO profile;
	private String  newEmail;



	private static Logger log = LogManager.getLogger(HealthCalendarController.class);
    
	
	public String resetCalendar(){
		resetMessages();
		if (!FacesContext.getCurrentInstance().isPostback()) {
    	    if(userPreferView.equals("list")){
    	    	viewType="eventView";
    	    }else{
    	    	viewType="calendarView";
    	    }
		}
		return "health";
	}
	
    
    @PostConstruct
    public void init(){
    	try{
	    	userprofileId = getUserProfileIdFromSession();
	    	schedule = (Schedule) FacesContext.getCurrentInstance().getViewRoot().findComponent("calendarSummaryForm:schedule");
    		if(userprofileId != null){
       		    setScheduleView(getUserPerferredView());
	    		setScheduleDate(new Date());
	    		exportCalendarDates();
	    		patientId=getPatientId();
	    	    eventModel = new DefaultScheduleModel();
	    	    getCalendarCategories();
	    	    loadSchedule(getDefaultSearchCriteria());
	    	    todos=findTodos(userprofileId);
	    	    if(getUserAccountType().equals("Premium")){
					refreshAppoinmentData();
					if(isAppointmentsChecked()){
					   getRefreshStatus(false);
					}
	    	    }
	    	    loadCalendarDates();
	    	    if(userPreferView.equals("list")){
	    	    	viewType="eventView";
	    	    }else{
	    	    	viewType="calendarView";
	    	    }
	    	    profile=getUserProfile();
				newEmail=profile.getContact().getEmail();
    		}
    	}catch(Exception e){
			log.error("Error initializing Calendar:",e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
    	}
        lastViewType=viewType;
    }
    
    
    private UserProfileDTO getUserProfile() throws MHVException{
    	return userMgmtService.getUserProfile(getUserProfileDTOFromSession().getUserName());
    }

	private String getUserPerferredView() throws MHVException {
    	userPreferView="month";
    	view="month";
    	try {
	    	  userPreference=calendarService.getUserCalViewForUser(userprofileId);
	    	  if(userPreference.getPreferredView().equals("MONTH")){
	    		  lastUserPreferView=userPreferView;
	    		  userPreferView="month";
	    		  view="month";
	    	  }else if(userPreference.getPreferredView().equals("DAY")){
	    		  lastUserPreferView=userPreferView;
	    		  userPreferView="agendaDay";
	    		  view="agendaDay";
	    	  }else if(userPreference.getPreferredView().equals("WEEK")){
	    		  lastUserPreferView=userPreferView;
	    		  userPreferView="agendaWeek";
	    		  view="agendaWeek";
	    	  }else if(userPreference.getPreferredView().equals("LIST")){
	    		  lastUserPreferView=userPreferView;
	    		  userPreferView="list";
	    		  view="month";
	    	  }
		} catch (MHVException e) {
			log.error("Error in getting User Perferences:");
			throw e;
     	}
    
    	return view;
	}

	private CalendarSearchCriteriaDTO getDefaultSearchCriteria() {
    	searchCriteria = new CalendarSearchCriteriaDTO();
 	    searchCriteria.setPatientId(patientId);
 	    searchCriteria.setUserProfileId(userprofileId);
 	    searchCriteria.setEventTypes(getSelectedEventTypes());
 	    searchCriteria.setKeyword(null);
 	    searchCriteria.setViewType(null);
	    return searchCriteria;
	}


	private void loadSchedule(CalendarSearchCriteriaDTO searchCriteria) throws MHVException {
    	try {
    		events=calendarService.findEventsForUser(searchCriteria);
    		eventModel = new DefaultScheduleModel();
    		if(events != null){
	    		for(MHVEventModel event: events){
	    			eventModel.addEvent(event);
	    		}
    		}
		} catch (MHVException e) {
			log.error("Error in finding User Events:", e);
			throw e;
		}
	}

	private void getCalendarCategories() throws MHVException {
    	try {
			calCategories=new ArrayList<CategoryDTO>();
    		List<CategoryDTO> calCatgs =calendarService.getCheckedCategories(userprofileId);
			int i=0;
			if(calCatgs !=null){
				
				for(CategoryDTO catg:calCatgs){
					if(!getUserAccountType().equals("Premium")&&catg.getCategory().equals("VA Appointments")){
					}else{
						calCategories.add(catg);
					}
				}
				for(CategoryDTO catg:calCategories){
					if(catg.getChecked()){
						selectedCategories[i]=catg.getCategory();
						i++;
					}
				}
			}
				
		} catch (MHVException e) {
        	log.error("Error in getting Calendar Categories:");
        	throw e;
		}
    }
	
	private void getAllCalendarCategories() throws MHVException {
    	try {
			calCategories=new ArrayList<CategoryDTO>();
    		List<CategoryDTO> calCatgs =calendarService.getAllCategories(userprofileId);
			int i=0;
			if(calCatgs !=null){
				
				for(CategoryDTO catg:calCatgs){
					if(!getUserAccountType().equals("Premium")&&catg.getCategory().equals("VA Appointments")&&catg.getCategory().equals("My Tasks")&&catg.getCategory().equals("My Recovery Plan")){
					}else{
						calCategories.add(catg);
					}
				}
				
				/**
				for(CategoryDTO catg:calCategories){
					if(catg.getChecked()){
						selectedCategories[i]=catg.getCategory();
						i++;
					}
				}
				**/
			}
				
		} catch (MHVException e) {
        	log.error("Error in getting Calendar Categories:");
        	throw e;
		}
    }
	
	

//*********************************To do actions start	********************************************
	
	public void toDoSummary(){
    	resetMessages();
    	todoTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("toDoForm:todoList");
    	lastViewType=viewType;
    	try{
    	    todos=findTodos(userprofileId);
        	viewType="todoView";
        	if (todoSortColumn != null && toDosortBy != null) {
        		todoTable.setValueExpression("sortBy", todoSortColumn);
        		todoTable.setSortOrder(toDosortBy);
			}
    	}catch(Exception e){
    	   log.error("Error in finding TODOS", e);
           FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
    	}
    }
    
    private List<ToDoTaskDTO> findTodos(Long userprofileId) throws MHVException {
    	List<ToDoTaskDTO> toDOList= null;
		try {
			toDOList = calendarService.getToDosForUser(userprofileId);
		} catch(MHVException e){
			log.error("Error in finding TODOS", e);
        	throw e;
        } 
		return toDOList;
	}
    
	public void onToDoSort(SortEvent event){
		todoSortColumn=event.getSortColumn().getValueExpression("sortBy");
		toDosortBy=event.isAscending()?"ascending":"descending";
	}
	
	public void showToDoDetail(ToDoTaskDTO todo) {
		resetMessages();
		selectedToDo = todo;
		lastViewType=viewType;
		viewType="showTodoView";
	}
	
	public void deleteTodoDisplay(ToDoTaskDTO todo) {
		resetMessages();
		selectedToDo = todo;
		lastViewType=viewType;
		viewType="deleteToDoView";
	}
	
	public void addToDoDisplay() {
  		resetMessages();
  	    newToDO = new ToDoTaskDTO();
  	    viewType="addTodoView";
		
		
    }
	
	public void saveTodo(Long todoId){
		ToDoTaskDTO todo;
		lastViewType=viewType;
		if(todoId != null && todoId !=0 ){
			todo=getSelectedToDo();
			viewType="showTodoView";
		}else{
			todo=getNewToDO();
			todo.setUserProfileId(userprofileId);
			viewType="addTodoView";
		}
		try {
			calendarService.saveToDoTask(todo);
			todos=findTodos(userprofileId);
			saveToDoMessage = true;
			viewType="todoView";
		} catch (MHVException e) {
			log.error("Error in Saving TODO", e);
        	super.processErrorMessages(e);
		}catch (Exception e) {
        	log.error("Error in Saving TODO:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	public void deleteTodo(Long todoId) {
		lastViewType=viewType;
		try {
			calendarService.deleteToDoTask(todoId);
			todos=findTodos(userprofileId);
			deleteToDoMessage = true;
			viewType="todoView";
		} catch (MHVException e) {
			log.error("Error in Deleting TODO", e);
        	super.processErrorMessages(e);
		} catch (Exception e) {
        	log.error("Error in Deleting TODO:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	public void printToDoSummary(){
		todoTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("toDoForm:todoList");
		lastViewType=viewType;
		viewType="printTodoSummaryView";
	}
	
	public void printToDo(){
		lastViewType=viewType;
		viewType="printTodoView";
	}
	
	
	public void backToToDoList(){
		resetMessages();
		viewType="todoView";
 	}
	
	public void backToToDo(){
		resetMessages();
		viewType="showTodoView";
 	}
	
	
	public void cancelAddTodo(){
	 	resetMessages();
     	viewType=lastViewType;
    	try {
			todos=findTodos(userprofileId);
		} catch (MHVException e) {
        	log.error("Error in find TODO:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    }


    
    public void cancelEditTodo(){
		lastViewType=viewType;
    	try {
			todos=findTodos(userprofileId);
		} catch (MHVException e) {
        	log.error("Error in find TODO:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
     	viewType="todoView";
    }
    
    public void todoDeleteDisplay(){
		lastViewType=viewType;
    	viewType="deleteToDoView";
    }
    
    public void todoFilter(){
    	String filterStatus;
    	try {
    		if(filterTodo==null){
    			filterStatus=" ";
    		}else{
    			filterStatus=filterTodo;
    		}
    		todos=calendarService.getFilteredToDosForUser(userprofileId,filterStatus);
		} catch (MHVException e) {
			log.error("Error in Filter TODO", e);
        	super.processErrorMessages(e);
		} catch (Exception e) {
        	log.error("Error in Filter TODO:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    }
 	
	//*********************To do actions End************************************************		
	
    
	//*********************************Event actions start	********************************************	
	//TODO visit this
    public void onViewChange(SelectEvent selectEvent) {
    	schedule = (Schedule) FacesContext.getCurrentInstance().getViewRoot().findComponent("calendarSummaryForm:schedule");
    	scheduleView=selectEvent.getObject().toString();
    	resetMessages();
    	viewType="calendarView";
    } 
    
    
    public void onDateSelect(SelectEvent selectEvent) {
    	resetMessages();
    	setScheduleView("agendaDay");
    	setScheduleDate((Date) selectEvent.getObject());
    	viewType="calendarView";
    } 
    
    public void addEventDisplay() {
		resetMessages();
		newEvent=new MHVEventModel();
		newEvent.setBeginDate(new Date());
		newEvent.setFinishDate(new Date());
		viewType="addEventView";
	}
 	 
    public void onEventSelect(SelectEvent selectEvent) throws IOException {
    	resetMessages();
		lastViewType=viewType;

    	selectedEvent = (MHVEventModel) selectEvent.getObject();
    	
    	if(selectedEvent.getEventType().equals("Personal Events")){
    		selectedEvent=findSelectedEvent(selectedEvent.getEventId());
    	}
    	
    	if(selectedEvent.getEventType().equals("VA Appointments")){
    		viewType="appointmentDetailView";
    	}else if(selectedEvent.getEventType().equals("Personal Events")){
    		setTimes(selectedEvent);
    		viewType="eventDetailView";
    	}else if(selectedEvent.getEventType().equals("My Tasks")){
    		viewType="taskDetailView";
    	}else{
    		viewType="genericEventDetailView";
    	}
    }
    

    
    private MHVEventModel findSelectedEvent(Long eventId){
    	MHVEventModel event=null;
		try {
			event = calendarService.getPersonalEventById(eventId);
		} catch (MHVException e) {
        	log.error("Error in Find Event:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    	return event;
    }
    


	public void showEventDetail(MHVEventModel event) {
		resetMessages();
		lastViewType=viewType;
		selectedEvent = event;
		if(selectedEvent.getEventType().equals("VA Appointments")){
    		viewType="appointmentDetailView";
    	}else if(selectedEvent.getEventType().equals("Personal Events")){
    		setTimes(selectedEvent);
    		viewType="eventDetailView";
    	}else if(selectedEvent.getEventType().equals("My Tasks")){
    		viewType="taskDetailView";
    	}else{
    		viewType="genericEventDetailView";
    	}
	}
    
    
	private void setTimes(MHVEventModel event) {
		
		String dateTime = CommonUtility.dateToString(event.getBeginDate(), HOUR_MINUTE);
		if (!dateTime.equals("00:00")) {
			event.setStartHour(CommonUtility.dateToString(event.getBeginDate(),HOURS));
			event.setStartMinute(CommonUtility.dateToString(event.getBeginDate(),MINUTES));
		}
		dateTime = CommonUtility.dateToString(event.getFinishDate(), HOUR_MINUTE);
		if (!dateTime.equals("00:00")) {
			event.setEndHour(CommonUtility.dateToString(event.getFinishDate(),HOURS));
			event.setEndMinute(CommonUtility.dateToString(event.getFinishDate(),MINUTES));
		}
	}

    
    
    public void eventSummary(){
    	resetMessages();
		lastViewType=viewType;
    	eventTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("calendarListForm:eventList");
    	currentMonth();
    	viewType="eventView";
    	if (eventSortColumn != null && eventsortBy != null) {
    		eventTable.setValueExpression("sortBy", eventSortColumn);
    		eventTable.setSortOrder(eventsortBy);
		}
    }
    
	public void onEventSort(SortEvent event){
		eventSortColumn=event.getSortColumn().getValueExpression("sortBy");
		eventsortBy=event.isAscending()?"ascending":"descending";
	}

    
    public void deleteEventDisplay() {
    	resetMessages();
    	viewType="eventDeleteView";
	}
    
    public void cancelEventDetail(){
    	viewType="eventDetailView";
    }
    
    public void saveEvent(Long eventId) {
    	CalendarEventDTO calEvent=new CalendarEventDTO();
    	MHVEventModel event=null;
		lastViewType=viewType;
    	if(eventId != null && eventId !=0 ){
    		event=getSelectedEvent();
    		viewType="eventDetailView";
		}else{
			event=getNewEvent();
			viewType="addEventView";
		}
    	setEventTimes(event);
    	convertToEventDTO(event,calEvent);
    	try {
    		calendarService.saveCalendarEvent(calEvent);
			saveEventMessage = true;
			loadSchedule(getDefaultSearchCriteria());
			viewType="calendarView";
		} catch (MHVException e) {
			log.error("Error in Save Event", e);
        	super.processErrorMessages(e);
    	}catch (Exception e) {
        	log.error("Error in Save Event:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
        }
	}
    
    
    
	private void setEventTimes(MHVEventModel event) {
		
		if(event.isAllDay()){
			event.setStartHour(null);
			event.setStartMinute(null);
			event.setEndHour(null);
			event.setEndMinute(null);
		}
		
		Date beginDateTime = null;
		if (event.getBeginDate() != null) {
			beginDateTime = CommonUtility.getDaTeTime(event.getBeginDate(), event.getStartHour(), event.getStartMinute());
		}
		event.setBeginDate(beginDateTime);
		Date endDateTime = null;
		if (event.getFinishDate() != null) {
			endDateTime = CommonUtility.getDaTeTime(event.getFinishDate(), event.getEndHour(), event.getEndMinute());
		}
		event.setFinishDate(endDateTime);
	}

    
	
    
    private void convertToEventDTO(MHVEventModel event,CalendarEventDTO calEvent) {
    	calEvent.setAllDay(event.isAllDay());
    	calEvent.setDescription(event.getDescription());
    	calEvent.setEndDate(event.getFinishDate());
    	calEvent.setEventId(event.getEventId());
    	calEvent.setLocation(event.getLocation());
    	calEvent.setRecurrenceInterval(event.getRepeatInterval());
    	calEvent.setRecurUntilDate(event.getRepeatEndDate());
    	calEvent.setRepeating(event.getRepeatEndDate() !=null );
    	calEvent.setStartDate(event.getBeginDate());
    	calEvent.setSubject(event.getEventName());
    	calEvent.setUserProfileId(userprofileId);
	}
    
    public void deleteEvent(Long eventId) {
		lastViewType=viewType;
    	try {
			calendarService.deleteCalendarEvent(eventId);
			//todos=findTodos(userprofileId);
			loadSchedule(getDefaultSearchCriteria());
			deleteEventMessage=true;
			viewType="calendarView";
		} catch (MHVException e) {
			log.error("Error in Deleting Event", e);
        	super.processErrorMessages(e);
		} catch (Exception e) {
        	log.error("Error in Deleting Event:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
    
    public void backToEventList(){
		resetMessages();
		//lastViewType=viewType;
     	viewType="eventView";
 	}
    

  
    public void cancelEvent(){
     	viewType=lastViewType;
    	try{
	        loadSchedule(getDefaultSearchCriteria());
    	}catch(Exception e){
	       	log.error("Error in finding Events:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    }
    
    public void backToEventDetail(){
    	viewType="eventDetailView";
    }
    
    public void backToGenericEventDetail(){
    	viewType="genericEventDetailView";
    }
    
    public void backToTaskDetail(){
    	viewType="taskDetailView";
    }
    
    public void backToAppointmentDetail(){
    	viewType="appointmentDetailView";
    }
    
    
    public void backToHealth(){
    	resetMessages();
    	setScheduleDate(selectedEvent.getStartDate());
     	if (viewType!="") {
     		viewType=lastViewType;
     	}
    }

    
    public void searchEventsAndTodos(){
    	lastViewType=viewType;
    	try {
    		searchResults = new ArrayList<MHVEventModel>();
    		ArrayList<MHVEventModel> tmpSearchResults = new ArrayList<MHVEventModel>();
    		maxSearchResults=false;
    		if(searchEventText != null && searchEventText.trim().length() > 0){
	    		CalendarSearchCriteriaDTO criteria = getDefaultSearchCriteria();
	    		criteria.setViewType("listView");
	    		criteria.setKeyword(searchEventText);
				List<MHVEventModel> srchResults=calendarService.searchEventsForUser(criteria);
				if(srchResults != null && srchResults.size() > 100){
					searchResultNumber=srchResults.size();
					searchResults=srchResults.subList(0, 100);
					maxSearchResults=true;
				}else{
					searchResults=srchResults;
				}
				
				
				Collections.reverse(searchResults);
				HashMap uniqueEvents = new HashMap();
				
				for (MHVEventModel search: searchResults) {
					String Key = search.getEventName();
					if (uniqueEvents.get(Key) == null){
						uniqueEvents.put(Key, search);
					}
					
						
					}
				
				tmpSearchResults.addAll(uniqueEvents.values());
					

				searchResults = tmpSearchResults;
				
				if(searchResults != null && searchResults.size() > 100){
					searchResultNumber=searchResults.size();
					searchResults=searchResults.subList(0, 100);
					maxSearchResults=true;
				}else{
					maxSearchResults=false;
				}
				
				Collections.sort(searchResults, new MHVEventComparator());
				//Collections.reverse(searchResults);
		
    		}
			viewType="searchResultsView";
		} catch (MHVException e) {
			log.error("Error in Searching Event", e);
        	super.processErrorMessages(e);
		} catch (Exception e) {
        	log.error("Error in Searching Event:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    }
    
    public void showSearchResultDetail(MHVEventModel event){
		resetMessages();
		lastViewType=viewType;
		selectedEvent = event;
		if(selectedEvent.getEventType().equals("VA Appointments")){
    		viewType="appointmentDetailView";
    	}else if(selectedEvent.getEventType().equals("Personal Events")){
    		setTimes(selectedEvent);
    		viewType="eventDetailView";
    	}else if(selectedEvent.getEventType().equals("My Tasks")){
    		viewType="taskDetailView";
    	}else if(selectedEvent.getEventType().equals("Todo")){
    		loadTodo(selectedEvent,selectedToDo);
    		viewType="showTodoView";
    	}else{
    		viewType="genericEventDetailView";
    	}

    }
	
    
    private void loadTodo(MHVEventModel selectedEvent,	ToDoTaskDTO selectedToDo) {
    	selectedToDo.setDescription(selectedEvent.getDescription());
    	selectedToDo.setDueDate(selectedEvent.getStartDate());
    	selectedToDo.setSubject(selectedEvent.getEventName());
    	selectedToDo.setToDoId(selectedEvent.getEventId());
    	selectedToDo.setToDoStatus(selectedEvent.getStatus());
    	selectedToDo.setUserProfileId(userprofileId);
	}


	//*********************************Event actions End	********************************************
    
    //******************************* AJAX Actions start ***********************************************
    
    
	public void dayViewAjax(){
		lastViewType="calendarView";
		try{
			resetMessages();
		    loadSchedule(getDefaultSearchCriteria());
			setScheduleView("agendaDay");
			setScheduleDate(new Date());
			setSelectDate(new Date());
			viewType="calendarView";
		}catch(Exception e){
	       	log.error("Error in finding Events:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	public void weekViewAjax(){
		lastViewType="calendarView";
		try{
			resetMessages();
		    loadSchedule(getDefaultSearchCriteria());
			setScheduleView("agendaWeek");
			setScheduleDate(new Date());
			setSelectDate(new Date());
			viewType="calendarView";
		}catch(Exception e){
	       	log.error("Error in finding Events:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	public void monthViewAjax(){
		lastViewType="calendarView";
		try{
			resetMessages();
		    loadSchedule(getDefaultSearchCriteria());
			setScheduleView("month");
			setScheduleDate(new Date());
			setSelectDate(new Date());
			viewType="calendarView";
		}catch(Exception e){
	       	log.error("Error in finding Events:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	 public void eventSummaryAjax(){
    	lastViewType="eventView";
    	resetMessages();
    	eventTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("calendarListForm:eventList");
    	currentMonth();
    	viewType="eventView";
     }
	 
	public void toDoSummaryAjax(){
    	lastViewType="todoView";
    	resetMessages();
    	filterTodo=null;
    	todoTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("toDoForm:todoList");
    	try{
    	    todos=findTodos(userprofileId);
    	}catch(Exception e){
    	   log.error("Error in finding TODOS", e);
           FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
    	}
     	viewType="todoView";
 	  }

	
	
	public void exportCalendarDates(){
		 Calendar cal = Calendar.getInstance();
		 cal.setTime(new Date());
		 cal.set(Calendar.DAY_OF_YEAR, 1);
		 cal.set(Calendar.MONTH, 0);
		 cal.set(Calendar.HOUR, 0);
		 cal.set(Calendar.MINUTE, 0);
		 cal.set(Calendar.SECOND, 0);
		 Date firstOfCurrentYear = cal.getTime();
		 cal.add(Calendar.YEAR, -7);
		 exportMinYear=cal.getTime();
		 cal.setTime(firstOfCurrentYear);
		 cal.add(Calendar.YEAR,8);
		 cal.add(Calendar.DATE, -1);
		 exportMaxYear=cal.getTime();
	}
	

	
	public void currentYearCalendars(){
	    minCalDate= CommonUtility.dateToString(getMinCurrentYear(), "MM/dd/yyyy");
	    maxCalDate= CommonUtility.dateToString(getMaxCurrentYear(), "MM/dd/yyyy");
	}
	

	public void nextYearCalendars(){
	    minCalDate= CommonUtility.dateToString(getMinNextYear(), "MM/dd/yyyy");
	    maxCalDate= CommonUtility.dateToString(getMaxNextYear(), "MM/dd/yyyy");
	}
	
	public void loadCalendarDates(){
		 Calendar cal = Calendar.getInstance();
		 cal.setTime(new Date());
		 cal.set(Calendar.DAY_OF_YEAR, 1);
		 cal.set(Calendar.MONTH, 0);
		 cal.set(Calendar.HOUR, 0);
		 cal.set(Calendar.MINUTE, 0);
		 cal.set(Calendar.SECOND, 0);
		 minCurrentYear=cal.getTime();
	     cal.add(Calendar.YEAR, 1);
	     minNextYear=cal.getTime();
	     cal.add(Calendar.DATE, -1);
	     maxCurrentYear=cal.getTime();
	     cal.add(Calendar.YEAR, 1);
	     maxNextYear = cal.getTime();
	     minCalDate= CommonUtility.dateToString(getMinCurrentYear(), "MM/dd/yyyy");
	     maxCalDate= CommonUtility.dateToString(getMaxCurrentYear(), "MM/dd/yyyy");
	     setSelectDate(new Date());
	}
	
	
	
	
	//******************************* AJAX Actions End ***********************************************
	
	public void exportDisplay() {
  		resetMessages();
  		lastViewType=viewType;
  		setExportStartDate(new Date());
		setExportEndDate(new Date());
  		exportCalCateories = new ArrayList<CategoryDTO>();
  		exportSelectedCategories= new String[50];
		for(CategoryDTO catg:calCategories){
			exportCalCateories.add(catg);
		}
		int i=0;
		for(String seletCatg:selectedCategories){
			exportSelectedCategories[i]=seletCatg;
			i++;
		}
		lastViewType=viewType;
  	    viewType="exportView";

  	    //return "export";
    }
	
	
	public void validateExportCriteria(){
		if(exportStartDate == null || exportEndDate == null || exportStartDate.after(exportEndDate)){
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			exportValidationError=true;
		}
	}
	
	public void exportCriteriaListener(){
		if(exportStartDate == null || exportEndDate == null || exportStartDate.after(exportEndDate)){
			exportValidationError=true;
		}else{
			exportValidationError=false;
		}
	}
	
	
	public void export() {
		
		try{
		calendarService.generateReport(userprofileId, getStrExportStartDate(), getStrExportEndDate(), getStrPatientId(), getExportEventTypes());
		}catch(Exception e){
			log.error("Exporting failed",e);
		}
	}


	public void updateView(){
	    List<String> eventTypes = new ArrayList<String>();
	    List<CategoryDTO> categoryDTOS = new ArrayList<CategoryDTO>();
	    for(String category:selectedCategories){
	    	if(category != null && category.trim().length() > 0){
		    	eventTypes.add(category);
		    	CategoryDTO dto = new CategoryDTO();
		    	dto.setCategory(category);
		    	dto.setChecked(Boolean.TRUE);
		    	categoryDTOS.add(dto);
	    	}else{
	    		break;
	    	}
	    }
	    searchCriteria.setEventTypes(eventTypes);
	   // searchCriteria.setRangeStart(null);
	    //searchCriteria.setRangeEnd(null);
	    try {
	        saveEventTypes(categoryDTOS, userprofileId);
	        if(isAppointmentsChecked()){
	           getRefreshStatus(false);
	        }
			loadSchedule(searchCriteria);
		} catch (Exception e) {
			log.error("Error updating view:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	    	    
    }
	
	private List<String> getSelectedEventTypes(){
		 List<String> eventTypes = new ArrayList<String>();
		   for(String category:selectedCategories){
		    	if(category != null && category.trim().length() > 0){
			    	eventTypes.add(category);
		    	}else{
		    		break;
		    	}
		    }
		   return eventTypes;
	}

	private void saveEventTypes(List<CategoryDTO> categoryDTOS, Long userProfileId) throws MHVException {
		try {
			  calendarService.saveUserCalCatList(categoryDTOS, userProfileId);
		} catch (MHVException e) {
			log.error("Error in saving Event types");
			throw e;
		}
	}
	
	public void savePreferences(){
		ContactDTO newContact=profile.getContact();
		newContact.setEmail(newEmail);
		resetMessages();
		try {
			calendarService.saveUserCalView(userPreference);
			savePreference=true;
		} catch (MHVException e) {
			log.error("Error in saving user preferences", e);
			super.processErrorMessages(e);
		}catch (Exception e) {
        	log.error("Error in Saving  user preferences:", e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		if (newEmail!=null ) {
			try {
				newContact.setEmail(newEmail);
				profile.setContact(newContact);
				this.userMgmtService.saveUserProfile(profile);
			} catch (MHVException e) {
				log.error("Unable to save profile", e);
			}
		}
	}

	public String dayView(){
		setScheduleView("agendaDay");
		lastViewType=viewType;
		viewType="calendarView";
		return "health";
	}
	public String weekView(){
		setScheduleView("agendaWeek");
		lastViewType=viewType;
		viewType="calendarView";
		return "health";

	}
	public String monthView(){
		setScheduleView("month");
		lastViewType=viewType;
		viewType="calendarView";
		return "health";
	}
	
	public void printHealth(){
		lastViewType=viewType;
		viewType="printHealthView";
	}
	
	public void printEventDetail(){
		viewType="printEventView";
	}
	
	public void printGenericEventDetail(){
		viewType="printGenericEventView";
	}
	
	public void printEventSummary(){
		eventTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("calendarListForm:eventList");
		viewType="printEventSummaryView";
	}
	
	public void printAppointmentDetail(){
		viewType="printAppointmentView";
	}
	
	public void printTaskDetail(){
		viewType="printTaskView";
	}
	
	public void preferencesView(){
		try{
			resetMessages();
			getUserPerferredView();
			lastViewType=viewType;
			profile=getUserProfile();
			newEmail=profile.getContact().getEmail();
			viewType="preferencesView";
		}catch(Exception e){
	  	   log.error("Error in finding TODOS", e);
           FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
	}
	
	public void jumpToDate(){
		lastViewType=viewType;
		viewType="selectDateView";
	}
	
	public void changeDate(){
		setScheduleDate(selectDate);
		setScheduleView("agendaDay");
		lastViewType=viewType;
		viewType="calendarView";
	}

	
	
    public void currentMonth(){
    	Calendar cal =Calendar.getInstance();
    	cal.setTime(new Date());
    	cal.set(Calendar.HOUR, 0);
    	cal.set(Calendar.MINUTE, 0);
    	cal.set(Calendar.SECOND, 0);
    	cal.set(Calendar.DAY_OF_MONTH, 1);
    	Date startDate=cal.getTime();
    	cal.add(Calendar.MONTH, 1);
    	cal.add(Calendar.DAY_OF_MONTH, -1);
    	
    	//cal.set(Calendar.HOUR, 23);
    	//cal.set(Calendar.MINUTE, 59);
    	//cal.set(Calendar.SECOND, 59);

    	
    	Date endDate=cal.getTime();
    	
    	searchCriteria.setRangeStart(startDate);
    	searchCriteria.setRangeEnd(endDate);
    	searchCriteria.setEventTypes(getSelectedEventTypes());
    	searchCriteria.setViewType("listView");
    	try {
			loadSchedule(searchCriteria);
		} catch (MHVException e) {
			log.error("Error Loading Calendar:",e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
    }
    
    public void nextMonth(){
    	Calendar cal =Calendar.getInstance();
    	cal.setTime(new Date());
    	cal.set(Calendar.HOUR, 0);
    	cal.set(Calendar.MINUTE, 0);
    	cal.set(Calendar.SECOND, 0);
    	cal.set(Calendar.DAY_OF_MONTH, 1);
    	cal.add(Calendar.MONTH, 1);
    	Date startDate=cal.getTime();
    	cal.add(Calendar.MONTH, 1);
    	cal.add(Calendar.DAY_OF_MONTH, -1);
    	
    	//cal.set(Calendar.HOUR, 23);
    	//cal.set(Calendar.MINUTE, 59);
    	//cal.set(Calendar.SECOND, 59);

    	
    	Date endDate=cal.getTime();
    	searchCriteria.setRangeStart(startDate);
    	searchCriteria.setRangeEnd(endDate);
    	searchCriteria.setEventTypes(getSelectedEventTypes());
    	searchCriteria.setViewType("listView");
    	try {
			loadSchedule(searchCriteria);
		} catch (MHVException e) {
			log.error("Error Loading Calendar:",e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}    	
    }
    
    public void currentYear(){
    	Calendar cal =Calendar.getInstance();
    	cal.setTime(new Date());
    	cal.set(Calendar.HOUR, 0);
    	cal.set(Calendar.MINUTE, 0);
    	cal.set(Calendar.SECOND, 0);
    	cal.set(Calendar.MONTH, 0);
    	cal.set(Calendar.DAY_OF_MONTH,1);
    	Date startDate=cal.getTime();
    	cal.add(Calendar.YEAR,1);
    	cal.add(Calendar.DAY_OF_MONTH, -1);
    	
    	//cal.set(Calendar.HOUR, 23);
    	//cal.set(Calendar.MINUTE, 59);
    	//cal.set(Calendar.SECOND, 59);

    	
    	Date endDate=cal.getTime();
    	searchCriteria.setRangeStart(startDate);
    	searchCriteria.setRangeEnd(endDate);
    	searchCriteria.setEventTypes(getSelectedEventTypes());
    	searchCriteria.setViewType("listView");
    	try {
			loadSchedule(searchCriteria);
		} catch (MHVException e) {
			log.error("Error Loading Calendar:",e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
     }
    
    public void nextYear(){
    	Calendar cal =Calendar.getInstance();
    	cal.setTime(new Date());
    	cal.set(Calendar.HOUR, 0);
    	cal.set(Calendar.MINUTE, 0);
    	cal.set(Calendar.SECOND, 0);
    	cal.set(Calendar.MONTH, 0);
    	cal.set(Calendar.DAY_OF_MONTH,1);
    	cal.add(Calendar.YEAR,1);
    	Date startDate=cal.getTime();
    	cal.add(Calendar.YEAR,1);
    	cal.add(Calendar.DAY_OF_MONTH, -1);
    	
    	//cal.set(Calendar.HOUR, 23);
    	//cal.set(Calendar.MINUTE, 59);
    	//cal.set(Calendar.SECOND, 59);

    	Date endDate=cal.getTime();
    	searchCriteria.setRangeStart(startDate);
    	searchCriteria.setRangeEnd(endDate);
    	searchCriteria.setEventTypes(getSelectedEventTypes());
    	searchCriteria.setViewType("listView");
    	try {
			loadSchedule(searchCriteria);
		} catch (MHVException e) {
			log.error("Error Loading Calendar:",e);
        	FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
	    }
    }
    
    public boolean isAppointmentsChecked(){
    	boolean appointmentsChecked=false;
    	 for(String category:selectedCategories){
    		 if(category != null && category.equals("VA Appointments")){
    			 appointmentsChecked=true;
    			 break;
    		 }
    	 }
    	 return appointmentsChecked;
    }
    
    

    
    private void refreshAppoinmentData() throws MHVException  {
		String patientIcn;
		try {
			patientIcn = getPatientICNFromSession();
			WebClient client= getPHRManagerWebClient().path("refresh").path(patientIcn).path("Appointments").
					         accept(CONTENT_TYPE).type(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			Response webserviceResponse=client.post(null);
			if(webserviceResponse.getStatus() == 200){
				log.debug("Response from PHR refresh service:",webserviceResponse.getEntity().toString() );
			}else{
				log.error("Error invoking PHR refresh service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			}
		} catch (MHVException e) {
			throw e;
		}
	}


	public String getRefreshStatus(boolean updateCalendar) throws MHVException {
		   log.debug("Inside  PHR-status service");
		   
		   if(getPatientICNFromSession() != null){
			   GsonBuilder builder = new GsonBuilder(); 
			   builder.registerTypeAdapter(Date.class, new JsonDeserializer<Date>() { 
				@Override
				public Date deserialize(JsonElement json, Type typeOfT,
						JsonDeserializationContext context)
						throws JsonParseException {
					return new Date(json.getAsJsonPrimitive().getAsLong()); 
				}

				});
			   Gson gson = builder.create();
			   WebClient client= getPHRManagerWebClient().path("status").path(getPatientICNFromSession()).
				         accept(CONTENT_TYPE).header(authenticationHeader, getAuthenticationHeaderValue());
			   Response webserviceResponse =client.get();
			   Date lastModified=null; 
			   if(webserviceResponse.getStatus() == 200){
				   Reader responseReader= new InputStreamReader ((InputStream)webserviceResponse.getEntity());
				   PatientExtractStatus patientExtractStatus= gson.fromJson(responseReader,PatientExtractStatus.class);
				   String FacilityExtractStatusjson=gson.toJson(patientExtractStatus.getFacilityExtractStatusList()) ;   
				   Type type = new TypeToken<List<FacilityExtractStatus>>() {}.getType();
				   Gson gson1= new Gson();
				   List<FacilityExtractStatus> facilityStausList = gson1.fromJson(FacilityExtractStatusjson, type);
				   for(FacilityExtractStatus extractStatus : facilityStausList){
					   if(extractStatus.getExtract().trim().equals("Appointments")){
						   lastModified = extractStatus.getLastModified();
						   break;
					   }
				   }
				   if(lastModified != null){
					   lastupdatedDate=lastModified.toString();
					   if(updateCalendar){
						   loadSchedule(searchCriteria);
					   }
				   }
				   
			   }else{
				   log.error("Error invoking PHR status service::"+ WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
			   }
	       }
		   return null;
	}


	
	public void addEventStartDateChange(){
		newEvent.setFinishDate(newEvent.getBeginDate());
	}
	
	public void editEventStartDateChange(){
		selectedEvent.setFinishDate(selectedEvent.getBeginDate());
	}
	

	public ScheduleModel getLazyEventModel() {
		return lazyEventModel;
	}

	public void setLazyEventModel(ScheduleModel lazyEventModel) {
		this.lazyEventModel = lazyEventModel;
	}



	public ToDoTaskDTO getSelectedToDo() {
		return selectedToDo;
	}


	public void setSelectedToDo(ToDoTaskDTO selectedToDo) {
		this.selectedToDo = selectedToDo;
	}


	public ToDoTaskDTO getNewToDO() {
		return newToDO;
	}


	public void setNewToDO(ToDoTaskDTO newToDO) {
		this.newToDO = newToDO;
	}



	 /*   lazyEventModel = new LazyScheduleModel() {
    
    @Override
    public void loadEvents(Date start, Date end) {
        Date random = getRandomDate(start);
        addEvent(new DefaultScheduleEvent("Lazy Event 1", random, random));
         
        random = getRandomDate(start);
        addEvent(new DefaultScheduleEvent("Lazy Event 2", random, random));
    }   
};  */

	public MHVEventModel getEvent() {
		return event;
	}

	public void setEvent(MHVEventModel event) {
		this.event = event;
	}

	public MHVEventModel getSelectedEvent() {
		return selectedEvent;
	}

	public void setSelectedEvent(MHVEventModel selectedEvent) {
		this.selectedEvent = selectedEvent;
	}

	

	public String getSearchEventText() {
		return searchEventText;
	}

	public List<ToDoTaskDTO> getTodos() {
		return todos;
	}



	public int getTodoRowsPerPage() {
		return todoRowsPerPage;
	}



	public void setTodoRowsPerPage(int todoRowsPerPage) {
		this.todoRowsPerPage = todoRowsPerPage;
	}



	public void setTodos(List<ToDoTaskDTO> todos) {
		this.todos = todos;
	}



	public void setSearchEventText(String searchEventText) {
		this.searchEventText = searchEventText;
	}

	public Schedule getSchedule() {
		return schedule;
	}

	public void setSchedule(Schedule schedule) {
		this.schedule = schedule;
	}

	public String getScheduleView() {
		return scheduleView;
	}

	public void setScheduleView(String scheduleView) {
		this.scheduleView = scheduleView;
	}

	public Date getScheduleDate() {
		return scheduleDate;
	}

	public void setScheduleDate(Date scheduleDate) {
		this.scheduleDate = scheduleDate;
	}

	public MHVEventModel getNewEvent() {
		return newEvent;
	}

	public void setNewEvent(MHVEventModel newEvent) {
		this.newEvent = newEvent;
	}
	

    public DataTable getTodoTable() {
		return todoTable;
	}


	public void setTodoTable(DataTable todoTable) {
		this.todoTable = todoTable;
	}



	public String[] getSelectedCategories() {
		return selectedCategories;
	}


	public void setSelectedCategories(String[] selectedCategories) {
		this.selectedCategories = selectedCategories;
	}


	

	public DefaultScheduleModel getEventModel() {
		return eventModel;
	}


	public void setEventModel(DefaultScheduleModel eventModel) {
		this.eventModel = eventModel;
	}


	public CalendarSearchCriteriaDTO getSearchCriteria() {
		return searchCriteria;
	}


	public void setSearchCriteria(CalendarSearchCriteriaDTO searchCriteria) {
		this.searchCriteria = searchCriteria;
	}


	public ValueExpression getTodoSortColumn() {
		return todoSortColumn;
	}


	public void setTodoSortColumn(ValueExpression todoSortColumn) {
		this.todoSortColumn = todoSortColumn;
	}


	public String getToDosortBy() {
		return toDosortBy;
	}


	public void setToDosortBy(String toDosortBy) {
		this.toDosortBy = toDosortBy;
	}


	public List<MHVEventModel> getEvents() {
		return events;
	}


	public void setEvents(List<MHVEventModel> events) {
		this.events = events;
	}


	public int getEventRowsPerPage() {
		return eventRowsPerPage;
	}


	public void setEventRowsPerPage(int eventRowsPerPage) {
		this.eventRowsPerPage = eventRowsPerPage;
	}


	public ValueExpression getEventSortColumn() {
		return eventSortColumn;
	}


	public void setEventSortColumn(ValueExpression eventSortColumn) {
		this.eventSortColumn = eventSortColumn;
	}


	public String getEventsortBy() {
		return eventsortBy;
	}


	public void setEventsortBy(String eventsortBy) {
		this.eventsortBy = eventsortBy;
	}


	public DataTable getEventTable() {
		return eventTable;
	}


	public void setEventTable(DataTable eventTable) {
		this.eventTable = eventTable;
	}


	public List<CategoryDTO> getCalCategories() {
		return calCategories;
	}


	public void setCalCategories(List<CategoryDTO> calCategories) {
		this.calCategories = calCategories;
	}


	public UserCalViewDTO getUserPreference() {
		return userPreference;
	}


	public void setUserPreference(UserCalViewDTO userPreference) {
		this.userPreference = userPreference;
	}


	public String getViewType() {
		return viewType;
	}


	public void setViewType(String viewType) {
		this.viewType = viewType;
	}


	public String getPreviousView() {
		return previousView;
	}


	public void setPreviousView(String previousView) {
		this.previousView = previousView;
	}


	public String getUserPreferView() {
		return userPreferView;
	}


	public void setUserPreferView(String userPreferView) {
		this.userPreferView = userPreferView;
	}


	public List<MHVEventModel> getSearchResults() {
		return searchResults;
	}


	public void setSearchResults(List<MHVEventModel> searchResults) {
		this.searchResults = searchResults;
	}


	public int getSearchResultsRowsPerPage() {
		return searchResultsRowsPerPage;
	}


	public void setSearchResultsRowsPerPage(int searchResultsRowsPerPage) {
		this.searchResultsRowsPerPage = searchResultsRowsPerPage;
	}


	public Date getSelectDate() {
		return selectDate;
	}


	public void setSelectDate(Date selectDate) {
		this.selectDate = selectDate;
	}


	public Date getMinCurrentYear() {
		return minCurrentYear;
	}


	public void setMinCurrentYear(Date minCurrentYear) {
		this.minCurrentYear = minCurrentYear;
	}


	public Date getMaxCurrentYear() {
		return maxCurrentYear;
	}


	public void setMaxCurrentYear(Date maxCurrentYear) {
		this.maxCurrentYear = maxCurrentYear;
	}


	public Date getMinNextYear() {
		return minNextYear;
	}


	public void setMinNextYear(Date minNextYear) {
		this.minNextYear = minNextYear;
	}


	public Date getMaxNextYear() {
		return maxNextYear;
	}


	public void setMaxNextYear(Date maxNextYear) {
		this.maxNextYear = maxNextYear;
	}


	public String getMinCalDate() {
		return minCalDate;
	}


	public void setMinCalDate(String minCalDate) {
		this.minCalDate = minCalDate;
	}


	public String getMaxCalDate() {
		return maxCalDate;
	}


	public void setMaxCalDate(String maxCalDate) {
		this.maxCalDate = maxCalDate;
	}


	public Integer getSearchResultNumber() {
		return searchResultNumber;
	}


	public void setSearchResultNumber(Integer searchResultNumber) {
		this.searchResultNumber = searchResultNumber;
	}


	public String getLastupdatedDate() {
		return lastupdatedDate;
	}


	public void setLastupdatedDate(String lastupdatedDate) {
		this.lastupdatedDate = lastupdatedDate;
	}




	public String getFilterTodo() {
		return filterTodo;
	}




	public void setFilterTodo(String filterTodo) {
		this.filterTodo = filterTodo;
	}




	public Date getExportStartDate() {
		return exportStartDate;
	}




	public void setExportStartDate(Date exportStartDate) {
		this.exportStartDate = exportStartDate;
	}




	public Date getExportEndDate() {
		return exportEndDate;
	}




	public void setExportEndDate(Date exportEndDate) {
		this.exportEndDate = exportEndDate;
	}




	public String[] getExportSelectedCategories() {
		return exportSelectedCategories;
	}




	public void setExportSelectedCategories(String[] exportSelectedCategories) {
		this.exportSelectedCategories = exportSelectedCategories;
	}




	public List<CategoryDTO> getExportCalCateories() {
		return exportCalCateories;
	}




	public void setExportCalCateories(List<CategoryDTO> exportCalCateories) {
		this.exportCalCateories = exportCalCateories;
	}




	public Date getExportMinYear() {
		return exportMinYear;
	}




	public void setExportMinYear(Date exportMinYear) {
		this.exportMinYear = exportMinYear;
	}




	public Date getExportMaxYear() {
		return exportMaxYear;
	}




	public void setExportMaxYear(Date exportMaxYear) {
		this.exportMaxYear = exportMaxYear;
	}



	public String getExportEventTypes() {
		
		boolean firstTime = true;
		StringBuffer sb = new StringBuffer();
		for(String catg:exportSelectedCategories){
			if(catg != null){
				String s1=null;
				boolean forwardSalsh=false;
				if(catg.contains("/")){
					s1 = catg.replaceAll("/", "~");
					forwardSalsh=true;
				}
				if(!firstTime){
					sb.append(",");
					if(forwardSalsh){
					  sb.append(s1);
					}else{
					  sb.append(catg);
					}
				}else{
					if(forwardSalsh){
					  sb.append(s1);
					}else{
					  sb.append(catg);	
					}
				}
				firstTime=false;
			}
		}
		return sb.toString();
	}




	public String getStrExportStartDate() {
		return 	CommonUtility.dateToString(getExportStartDate(), "MMddyyyy");
	}
	

	public String getStrExportEndDate() {
		return 	CommonUtility.dateToString(getExportEndDate(), "MMddyyyy");
	}
	

	public String getStrPatientId() {
		String patId=" ";
		Long patientId = getPatientId();
		if(patientId != null){
			patId=String.valueOf(patientId);
		}
		return patId;
	}




	public boolean isExportValidationError() {
		return exportValidationError;
	}




	public void setExportValidationError(boolean exportValidationError) {
		this.exportValidationError = exportValidationError;
	}




	public String getServerTimeZone() {
		TimeZone tz = TimeZone.getDefault();
		return tz.getID();
	}


	public String getView() {
		return view;
	}


	public void setView(String view) {
		this.view = view;
	}
	
	public String getEditTaskDetailsUrl()  {
	String url = "";

	log.debug("getEditTaskDetailsUrl");
			
	try {
		if (selectedEvent == null || (selectedEvent != null && !selectedEvent.getEventType().equals("My Tasks"))) {
			return "";
		}

		log.debug("eventId=" + selectedEvent.getEventId());
		log.debug("getEventName=" + selectedEvent.getEventName());
		log.debug("getLocation=" + selectedEvent.getLocation());

		PortletRequest portletRequest = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		ServiceContext serviceContext = ServiceContextFactory.getInstance(portletRequest);
		String portletId = serviceContext.getPortletId();
		long plid = serviceContext.getPlid();
		String lifecycle = PortletRequest.RENDER_PHASE;
			
		boolean found = false;
		List<Portlet> list = PortletLocalServiceUtil.getPortlets();
		for (Portlet p : list) {
			if (p.getPortletName().equalsIgnoreCase("myGoalsViewAndTrackGoals")) {
				portletId = p.getPortletId();
				log.debug("found=" + portletId);
				found = true;
				break;

			}
		}
		
		if (!found) {
			log.debug("Missing MyGoals portlet");
			return "";
		}
		
		MyTaskSearchDTO myTaskSearchDTO = new MyTaskSearchDTO();
		
		myTaskSearchDTO.setUserProfileId(this.userprofileId);
		
		String taskName = selectedEvent.getEventName();
		taskName = taskName.replace("[My Tasks] ", "");
		myTaskSearchDTO.setTaskName(taskName);

		String goalName = selectedEvent.getLocation();
		goalName = goalName.replace("[My Tasks] ", "");
		myTaskSearchDTO.setGoalName(goalName);
		
		log.debug("taskName=" + taskName + ", goalName=" + goalName);

		MyTaskSearchDTO result = myGoalsService.getMyGoalsTaskByName(userprofileId, myTaskSearchDTO);
		
		if (result == null) {
			log.debug("no results");
		}
				
		LiferayPortletURL portletURL = PortletURLFactoryUtil.create(portletRequest, portletId, plid, lifecycle);
		portletURL.setWindowState(WindowState.NORMAL);
		portletURL.setPortletMode(PortletMode.VIEW);
		portletURL.setParameter("_facesViewIdRender", "/views/trackgoals/view_goal_step4C.xhtml");
		
		if (result != null) {
			portletURL.setParameter("goalId", result.getGoalId().toString());
			portletURL.setParameter("taskId", result.getTaskId().toString());
		} else {
			portletURL.setParameter("goalId", "0");
			portletURL.setParameter("taskId", "0");
		}
		
		url = portletURL.toString();
		
		log.debug("portletUrl=" + url);
		
		url = url.replace("health-calendar", "view-and-track-my-goals");
		
	} catch (Exception e) {
		log.debug(e);
	}
	
	log.debug("url=" + url);
	
	return url;
		
}
	

	public UserProfileDTO getProfile() {
		return profile;
	}


	public void setProfile(UserProfileDTO profile) {
		this.profile = profile;
	}


	public String getNewEmail() {
		return newEmail;
	}


	public void setNewEmail(String newEmail) {
		this.newEmail = newEmail;
	}


	public String getLastUserPreferView() {
		return lastUserPreferView;
	}


	public void setLastUserPreferView(String lastUserPreferView) {
		this.lastUserPreferView = lastUserPreferView;
	}




}
