package gov.va.med.mhv.calendar.web.controller;

import gov.va.med.mhv.calendar.service.CalendarService;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;
import gov.va.med.mhv.usermgmt.common.dto.HealthInfoDTO;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.Serializable;
import java.util.Map;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;


public abstract class AbstractController implements Serializable {

	private static final long serialVersionUID = -8611610134485398648L;
	private static Logger log = LogManager.getLogger(AbstractController.class);
	private String firstName;
	private String lastName;
	protected static final String  DEFAULT_HOUR ="23";
	protected static final String  DEFAULT_MINUTE ="59";
	protected static final String  DEFAULT_DATETIME ="23:59";
	protected static final String  HOUR_MINUTE ="HH:mm";
	protected static final String  HOURS ="HH";
	protected static final String  MINUTES ="mm";
	protected Boolean saveEventMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteEventMessage = false;
	protected Boolean saveToDoMessage = false;
	protected Boolean deleteToDoMessage = false;
	protected Boolean savePreference=false;
	protected boolean maxSearchResults;

	protected String period;
	protected static final String  YYYYMMDD_FORMAT ="yyyyMMdd";
	protected static final String  YYYY_MM_DD_HHMMSS_FORMAT="yyyy-MM-dd";
	protected static final String CHART_EXTENDER="chartExtender";
	protected static final String DAYS ="dd";
	protected static final String MONTHS="MM";
	protected static final String YEARS="yyyy";
	protected static final String NO_DATA="No data available";
	protected static final String ERR_PRCS_RQST="Error Processing request";
	protected static final String CONTENT_TYPE="application/json";
	protected static final String authenticationHeader ="X-Authorization-Key";
	private String deleteOrigin;
	private static final String USER_PROFILE_ID_KEY = "LIFERAY_SHARED_userprofileid";
	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	
	private static final String PATIENT_ICN_KEY = "LIFERAY_SHARED_patienticn";
	protected Long userprofileId;
	protected String userAccountType;
	private static final String API_SESSION_TOKEN_KEY = "APISessionToken";
	
	protected String searchEventText;

	
	@Resource(name = "calendarServiceProxy")
	protected CalendarService calendarService;

	@Resource(name = "myGoalsServiceProxy")
	protected MyGoalsWebService myGoalsService;

	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtService;
	
	@Value("${appContextroot}")
	private String appContextRoot;
	
	@Value("${phrManagerendpointUrl}")
	private String phrManagerendpointUrl;

	@Value("${endpointUrl}")
	private String userManagmentendpointUrl;
	
	
	@Value("${phrmgr.xauth.key}")
	private String authenticationHeaderValue;
	
	@Autowired
	private ObjectMapper mapper;


	protected WebClient getUserManagmentWebClient() {
	    log.debug("Usermanagement endpoint##:");
	    log.debug(userManagmentendpointUrl);
		return WebClient.create(getUserManagmentendpointUrl());
	}

	
	protected Long getUserProfileIdFromSession() throws MHVException {
		Long userProfileId=0l;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			userProfileId = (Long)session.getAttribute(USER_PROFILE_ID_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get UserProfile Id from session");
		}
		
		
		return userProfileId;
	}
	
	protected String getPatientICNFromSession() throws MHVException {
		String patientICN;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			patientICN = (String)session.getAttribute(PATIENT_ICN_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get Patient ICN from session");
		}
		return patientICN;
	}
	
	protected WebClient getPHRManagerWebClient() {
	    log.debug("PHR Manager endpoint##:");
	    log.debug(phrManagerendpointUrl);
		return WebClient.create(phrManagerendpointUrl);
	}


	protected void processErrorMessages(MHVException exp) {
		// response has errors
		if (null != exp.getErrorCode()) {
			Map<String, String> validationErrors = exp.getValidationErrorMessages();

			if (log.isDebugEnabled()) {
				int size = null != validationErrors ? validationErrors.size() : 0;
				log.debug("validationErrors.size() : " + size);
			}

			// check if there are any validation errors in response object
			if (null != validationErrors && validationErrors.size() > 0) {

				for (Map.Entry<String, String> err : validationErrors.entrySet()) {
					if (log.isDebugEnabled()) {
						if (null != err) {
							log.debug("entry.getKey() : " + err.getKey());
							log.debug("entry.getValue() : " + err.getValue());
						}
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
				}
			}

			// check for non-validation errors in response object
			if (null != exp.getFailureMessage() && exp.getFailureMessage().length() > 0) {
				if (log.isDebugEnabled()) {
					log.debug("FailureMessage : " + exp.getFailureMessage());
				}

				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
	}


	protected Gson getGsonTimeStamp() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").serializeNulls().create();
	}

	protected Gson getGson() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd").serializeNulls().create();
	}

	
	protected Gson getGsonWithoutDateFormat() {
		return new GsonBuilder().serializeNulls().create();
	}
	
	protected Gson getGsonTimeMilli() {
		return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS a").serializeNulls().create();
	}
	
	public String getAppContextRoot() {
		return appContextRoot;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		return  context;
    }

	public void findUser() {
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user=null;
        try{
        	user =PortalUtil.getUser(request);
        }catch(Exception e){
        	
        }
		if(user != null){
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}
	
	public Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid",
				PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
	
	public Long getPatientId(){
		Object patId=null;
		Long patientId=null;
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session =request.getPortletSession();
		patId =session.getAttribute("LIFERAY_SHARED_patientid",PortletSession.APPLICATION_SCOPE);
    	if(patId != null){
    		patientId=(Long)patId;
    	}
    	return patientId;
	}
	
	protected void resetMessages(){
		saveEventMessage = false;
		saveAndAddMessage = false;
		deleteEventMessage = false;
		saveToDoMessage = false;
		deleteToDoMessage = false;
		savePreference=false;
		maxSearchResults=false;
		searchEventText=null;
	}
	
	
	protected String getUserAccountType() {
		String userAccountType=null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_accountType",PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userAccountType = (String) profileId;
		}
		return userAccountType;
	}
	
	
	public String getAPIToken() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String token = (String)session.getAttribute(API_SESSION_TOKEN_KEY);
		
		return token;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}



	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}




	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}


	public String getDeleteOrigin() {
		return deleteOrigin;
	}



	public void setDeleteOrigin(String deleteOrigin) {
		this.deleteOrigin = deleteOrigin;
	}




	public Boolean getSaveEventMessage() {
		return saveEventMessage;
	}



	public void setSaveEventMessage(Boolean saveEventMessage) {
		this.saveEventMessage = saveEventMessage;
	}



	public Boolean getDeleteEventMessage() {
		return deleteEventMessage;
	}



	public void setDeleteEventMessage(Boolean deleteEventMessage) {
		this.deleteEventMessage = deleteEventMessage;
	}



	public Boolean getSaveToDoMessage() {
		return saveToDoMessage;
	}



	public void setSaveToDoMessage(Boolean saveToDoMessage) {
		this.saveToDoMessage = saveToDoMessage;
	}



	public Boolean getDeleteToDoMessage() {
		return deleteToDoMessage;
	}



	public void setDeleteToDoMessage(Boolean deleteToDoMessage) {
		this.deleteToDoMessage = deleteToDoMessage;
	}
	public Boolean getSavePreference() {
		return savePreference;
	}
	public void setSavePreference(Boolean savePreference) {
		this.savePreference = savePreference;
	}
	public boolean isMaxSearchResults() {
		return maxSearchResults;
	}
	public void setMaxSearchResults(boolean maxSearchResults) {
		this.maxSearchResults = maxSearchResults;
	}

	public String getAuthenticationHeaderValue() {
		return authenticationHeaderValue;
	}

	public void setAuthenticationHeaderValue(String authenticationHeaderValue) {
		this.authenticationHeaderValue = authenticationHeaderValue;
	}
	

	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext()
					.getRequest();
			session = request.getPortletSession();

			String patientStr = (String) session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(patientStr, UserProfileDTO.class);

		} catch (Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}

	
	protected String saveUserProfile(UserProfileDTO userProfile) throws MHVException {
		try {
			if (log.isDebugEnabled()) {
				log.debug("inside saveUserProfile");
			}
			this.userMgmtService.saveUserProfile(userProfile);
		} catch (MHVException e) {
			log.error("Error in storing updated user profile details: ", e);
			if (null != e.getFailureMessage() && e.getFailureMessage().length() > 0) {
				String errorMessage = e.getFailureMessage();
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
			}
		}

		return null;
	}


	public String getUserManagmentendpointUrl() {
		return userManagmentendpointUrl;
	}
	
}

