package gov.va.med.mhv.calendar.web.bean;

import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class PhrStatusBean implements Serializable {
	private static final long serialVersionUID = -4455323209252190285L;

	private static Logger logger = LogManager.getLogger(PhrStatusBean.class);

	private PatientExtractStatus status;

	private Boolean isRefreshCompleteForImaging = false;
	private Boolean isRefreshComplete = false;
	private Boolean isRefreshNeeded = false;
	private Boolean showCompleteBBMI = true;
	
	public boolean getIsRefreshCompleteForImaging() {
		return isRefreshCompleteForImaging;
	}

	public void setIsRefreshCompleteForImaging(Boolean isRefreshCompleteForImaging) {
		this.isRefreshCompleteForImaging = isRefreshCompleteForImaging;
	}

	public boolean getIsRefreshComplete() {
		return isRefreshComplete;
	}

	public void setIsRefreshComplete(Boolean isRefreshComplete) {
		this.isRefreshComplete = isRefreshComplete;
	}

	public boolean getIsRefreshNeeded() {
		return isRefreshNeeded;
	}

	public void setIsRefreshNeeded(Boolean isRefreshNeeded) {
		this.isRefreshNeeded = isRefreshNeeded;
	}

	public boolean getShowCompleteForBBMI() {
		assert(status != null);
		
		boolean result = showCompleteBBMI && getRefreshComplete("ImagingStudy");

		if (result) {
			setShowCompleteForBBMI(false);
		}

		return result;
	}

	public void setShowCompleteForBBMI(Boolean showCompleteBBMI) {
		this.showCompleteBBMI = showCompleteBBMI;
	}
	
	
	public boolean getIsPatientExtractStatusLoaded() {
		return !(status == null);
	}

	public PatientExtractStatus getPatientExtractStatus() {
		return status;
	}

	public void setPatientExtractStatus(PatientExtractStatus status) {
		this.status = status;
		
		//Compile and set the statuses once
		this.setIsRefreshComplete(getRefreshComplete());
		this.setIsRefreshNeeded(getRefreshNeeded());
		this.setIsRefreshCompleteForImaging(getRefreshComplete("ImagingStudy"));
	}

	/**
	 * Check if inProgress and was it updated today?
	 * 
	 * @return
	 */
	private boolean getRefreshComplete() {
		Boolean isComplete = true;
		assert(status != null);
		
		if (status.getFacilityExtractStatusList() == null) {
			isComplete = false;
		} else if( status.getFacilityExtractStatusList().size() == 0 ) {
			isComplete = false;
		} else if( status.getFacilityExtractStatusList().size() > 0 ) {
			Date today = new Date();
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				if (facilityExtractStatus.getLastCompleted() == null) {
					isComplete = false;
					break;
				} else if (facilityExtractStatus.getLastCompleted() != null) {
					isComplete = status.isSameDate(today, facilityExtractStatus.getLastRequested());
				}
				
				if( !isComplete ) {
					break;
				}
			}
		}
		if (logger.isDebugEnabled()) {
			logger.debug("Found that PHR is complete? " + isComplete);
		}
		return isComplete;
	}

	public boolean getRefreshHasErrors() {
		Boolean hasErrors = false;
		assert(status != null);
		
		if( status.getFacilityExtractStatusList().size() > 0 ) {
			Date today = new Date();
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				if (facilityExtractStatus.getLastCompleted() != null && status.isSameDate(today, facilityExtractStatus.getLastRequested()) ) {
					if( facilityExtractStatus.getLoadStatus().equals("ERROR")) {
						hasErrors = true;
					}
				}
				if( hasErrors ) {
					break;
				}
			}
		}
		if (logger.isDebugEnabled()) {
			logger.debug("Found that PHR has Errors? " + hasErrors);
		}
		return hasErrors;
	}

	public List<String> getDomainsWithErrors() {
		assert(status != null);
		
		List<String> domains = new ArrayList<String>();
	
		List<String> errorExtracts = new ArrayList<String>();
		Date today = new Date();
		
		for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
			if (fes.getLastCompleted() != null && !status.isSameDate(today, fes.getLastRequested()) ) {
				if( fes.getLoadStatus().equals("ERROR")) {
					errorExtracts.add(fes.getExtract());
				}
			}
		}
		
		if(errorExtracts.contains("Allergy")) {
			domains.add("VA Allergies");
		}
		
		if(errorExtracts.contains("Appointments")) {
			domains.add("VA Appointments");
		}
		
		if(errorExtracts.contains("WellnessReminders")) {
			domains.add("VA Wellness Reminders");
		}
		
		if(errorExtracts.contains("VPR") && errorExtracts.contains("ChemistryHematology")) {
			domains.add("VA Laboratory Results: Chemistry/Hematology/Microbiology");
		} else if ( !errorExtracts.contains("VPR") && errorExtracts.contains("ChemistryHematology") ) {
			domains.add("VA Laboratory Results: Chemistry/Hematology");
		} else if(errorExtracts.contains("VPR") && !errorExtracts.contains("ChemistryHematology")) {
			domains.add("VA Laboratory Results: Microbiology");
		}
		
		if(errorExtracts.contains("ImagingStudy")) {
			domains.add("VA Medical Imaging and Reports");
		}
		
		if(errorExtracts.contains("VPR")) {
			domains.add("VA Admissions and Discharges");
			domains.add("VA Demographics");
			domains.add("VA Electrocardiogram (EKG)");
			domains.add("VA Immunizations");
			domains.add("VA Pathology Reports: Surgical Pathology/Cytology/Electron Microscopy");
			domains.add("VA Problem List");
			domains.add("VA Notes");
			domains.add("VA Radiology");
			domains.add("VA Vitals and Readings");
		}
		
		Collections.sort(domains);

		if(errorExtracts.contains("DodMilitaryService")) {
			domains.add("DOD Military Service Data");
		}
		
		return domains;
	}
	
	/**
	 * Check if inProgress and was it updated today?
	 * 
	 * @return
	 */
	private boolean getRefreshComplete(String extract) {
		assert(status != null);
		
		if (status.getFacilityExtractStatusList() == null) {
			return false;
		} else if( status.getFacilityExtractStatusList().size() == 0 ) {
			return false;
		} else if( status.getFacilityExtractStatusList().size() > 0 ) {
			Date today = new Date();
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				if( facilityExtractStatus.getExtract().equals(extract)) {
					if (facilityExtractStatus.getLastCompleted() == null) {
						return false;
					} else if (facilityExtractStatus.getLastCompleted() != null) {
						boolean done = status.isSameDate(today, facilityExtractStatus.getLastRequested()); 
						if (logger.isDebugEnabled()) {
							logger.debug("Found that PHR extract " + extract + " is complete? " + done);
						}
						return done;
					}
				}
			}
		} 

		return false;
	}
	
	private boolean getRefreshNeeded() {
		Boolean isNeeded = false;

		assert(status != null);

		//If there are no records return true
		//Else if there are any extract records for <today return true
		//Else return false
		if (status.getFacilityExtractStatusList() == null) {
			isNeeded = true;
		} else if (status.getFacilityExtractStatusList().size() == 0) {
			isNeeded = true;
		} else if (status.getFacilityExtractStatusList().size() > 0) {
			Date today = new Date();
			for (FacilityExtractStatus facilityExtractStatus : status.getFacilityExtractStatusList()) {
				isNeeded = !status.isSameDate(today, facilityExtractStatus.getLastRequested());
				if (isNeeded) {
					break;
				}
			}
		} 
		
		if (logger.isDebugEnabled()) {
			logger.debug("Found that PHR needs to be refreshed? " + isNeeded);
		}
		return isNeeded;
	}

	public Date getLastModifiedForBBMI() {
		return getLastModifiedForExtract("ImagingStudy");
	}
	
	private Date getLastModifiedForExtract(String extract) {
		Date response = new Date();
		if (status != null && status.getFacilityExtractStatusList() != null) {
			for (FacilityExtractStatus s : status.getFacilityExtractStatusList()) {
				if (s.getExtract().trim().equalsIgnoreCase(extract)) {
					if (s.getLastModified() != null) {
						//response = CommonUtility.dateToStringTimeZone( s.getLastModified(), "MM/dd/yyyy") + " at " + CommonUtility.dateToStringTimeZone(s.getLastModified(), "HH:mm");
						response = s.getLastModified();
						break;
					}
				}
			}
		}
		return response;
	}
	
	/**
	 * 	Appointments
		Allergy
		ChemistryHematology
		WellnessReminders
		DodMilitaryService
		VPR
		ImagingStudy
	 * @return
	 */
	
	public List<String> getInProgressDomains() {
		assert(status != null);
		
		List<String> domains = new ArrayList<String>();
	
		List<String> inProgressExtracts = new ArrayList<String>();
		Date today = new Date();
		if(status != null) {
		for( FacilityExtractStatus fes: status.getFacilityExtractStatusList())  {
			if (fes.getLastCompleted() == null) {
				inProgressExtracts.add(fes.getExtract());
			} else if (fes.getLastCompleted() != null && !status.isSameDate(today, fes.getLastRequested()) ) {
				inProgressExtracts.add(fes.getExtract());
			}
		}
		}
		if(inProgressExtracts.contains("Allergy")) {
			domains.add("VA Allergies");
		}
		
		if(inProgressExtracts.contains("Appointments")) {
			domains.add("VA Appointments");
		}
		
		if(inProgressExtracts.contains("WellnessReminders")) {
			domains.add("VA Wellness Reminders");
		}
		
		if(inProgressExtracts.contains("VPR") && inProgressExtracts.contains("ChemistryHematology")) {
			domains.add("VA Laboratory Results: Chemistry/Hematology/Microbiology");
		} else if ( !inProgressExtracts.contains("VPR") && inProgressExtracts.contains("ChemistryHematology") ) {
			domains.add("VA Laboratory Results: Chemistry/Hematology");
		} else if(inProgressExtracts.contains("VPR") && !inProgressExtracts.contains("ChemistryHematology")) {
			domains.add("VA Laboratory Results: Microbiology");
		}
		
		if(inProgressExtracts.contains("ImagingStudy")) {
			domains.add("VA Medical Imaging and Reports");
		}
		
		if(inProgressExtracts.contains("VPR")) {
			domains.add("VA Admissions and Discharges");
			domains.add("VA Demographics");
			domains.add("VA Electrocardiogram (EKG)");
			domains.add("VA Immunizations");
			domains.add("VA Pathology Reports: Surgical Pathology/Cytology/Electron Microscopy");
			domains.add("VA Problem List");
			domains.add("VA Notes");
			domains.add("VA Radiology");
			domains.add("VA Vitals and Readings");
		}
		
		Collections.sort(domains);

		if(inProgressExtracts.contains("DodMilitaryService")) {
			domains.add("DOD Military Service Data");
		}
		
		return domains;
	}
	
	public List<String> getImagingDomain() {
		List<String> domains = new ArrayList<String>();
		domains.add("VA Medical Imaging and Reports");
		return domains;
	}
	
}


//public String getLoadStatusForExtract(String extract) {
//String response = "Unavailable";
//if (status != null && status.getFacilityExtractStatusList() != null) {
//	for (FacilityExtractStatus s : status.getFacilityExtractStatusList()) {
//		if (s.getExtract().trim().equalsIgnoreCase(extract)) {
//			response = s.getLoadStatus();
//			break;
//		}
//	}
//}
//return response;
//}
