package gov.va.med.mhv.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.calendar.converter.UserCalViewConverter;
import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.calendar.dto.VisnDTO;
import gov.va.med.mhv.calendar.model.ApiCategory;
import gov.va.med.mhv.calendar.model.CalViewApiReminder;
import gov.va.med.mhv.calendar.model.UserCalView;
import gov.va.med.mhv.calendar.model.VisnLookup;
import gov.va.med.mhv.calendar.repository.ApiCategoryRepository;
import gov.va.med.mhv.calendar.repository.CalViewApiReminderRepository;
import gov.va.med.mhv.calendar.repository.UserCalViewRepository;
import gov.va.med.mhv.calendar.repository.VisnRepository;
import gov.va.med.mhv.calendar.service.UserCalViewService;
import gov.va.med.mhv.calendar.service.VisnService;
import gov.va.med.mhv.calendar.validator.PreferencesValidator;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public class UserCalViewServiceImpl implements UserCalViewService {
	private static Logger log = LogManager.getLogger(UserCalViewServiceImpl.class);

	@Autowired
	private UserCalViewRepository userCalViewRepository;
	
	@Autowired
	private VisnRepository visnRepository;
	
	@Autowired
	private PreferencesValidator validator;
	
	@Autowired
	private CalViewApiReminderRepository calViewApiReminderRepository;
	
	@Autowired
	private ApiCategoryRepository apiCategoryRepository;

	
	@Override
	public String test(String sampleText) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<UserCalViewDTO> getUsersForVhaReminderByVisn(Long visnId) throws MHVException {
		List<UserCalViewDTO> userCalViewDtos = null;
		List<UserCalView> userCalViews = null;

		try {
			userCalViews = userCalViewRepository.getUsersForVhaReminderByVisn(visnId);
		} catch (Exception e) {
			log.error("Error in fetching all active categories " + e);
			throw new MHVException(e);			
		}

		if(userCalViews==null || userCalViews.size()==0) {
			userCalViews = new ArrayList<UserCalView>();
		}

		userCalViewDtos = (null != userCalViews) ? new UserCalViewConverter().convert(userCalViews) : null;

		return userCalViewDtos;	
	}
	

	@Override
	public List<UserCalViewDTO> getUserCalViewForUser(Long userProfileId) throws MHVException {
		List<UserCalViewDTO> userCalViewDtos = null;
		List<UserCalView> userCalViews = null;
		userCalViewDtos= new ArrayList<UserCalViewDTO>();

		try {
			userCalViews = userCalViewRepository.getUserCalViewForUser(userProfileId);
		} catch (Exception e) {
			log.error("Error in fetching all active categories " + e);
			throw new MHVException(e);			
		}
		if(userCalViews==null || userCalViews.size()==0) {
			userCalViews = new ArrayList<UserCalView>();
		}
		List<UserCalViewDTO> dtos = (null != userCalViews) ? new UserCalViewConverter().convert(userCalViews) : null;

		if (dtos!=null && dtos.size() >0 ) {
			UserCalViewDTO dto=dtos.get(0);
			List<CalViewApiReminder> reminders= calViewApiReminderRepository.getUsersCalViewApiReminderForUser(dto.getUserCalViewId());
			if(reminders != null){
				for(CalViewApiReminder reminder: reminders){
					ApiCategory apicat=apiCategoryRepository.findOne(reminder.getApiCatID());
					if(apicat.getApiCatName().equals("My Tasks")){
						dto.setMyTasks(true);
					}
					if(apicat.getApiCatName().equals("My Recovery Plan Events")){
						dto.setMyRecoveryEvents(true);
					}
				}
				userCalViewDtos.add(dto);
			}
		}
		else {
			UserCalViewDTO newDto = new UserCalViewDTO();
			newDto.setPreferredView("LIST");
			newDto.setVhaReminders(false);
			newDto.setPersonalEventFilter(false);
			newDto.setZipCode("");
			newDto.setUserProfileId(userProfileId);
			newDto.setVisn(new VisnDTO());
			newDto.setMyRecoveryEvents(false);
			userCalViewDtos.add(newDto);

		}


		return userCalViewDtos;	
	}
	

	@Transactional
	@Override
	public void saveUserCalView(UserCalViewDTO userCalViewDto) throws MHVException {
		ResponseUtil <UserCalViewDTO> response = new ResponseUtil <UserCalViewDTO>();
		UserCalView userCalView= null;
		
		Long retrievedVisn = 0L;
		String retrievedZip = null;
		Boolean zipCodeFound = false;
		
		try {
			
			  //  update the VISN number per the zip code entered
				if (userCalViewDto.getZipCode() != null && !userCalViewDto.getZipCode().isEmpty() ) {
					VisnLookup visnLook = null;
					visnLook = visnRepository.getVisnLookupByPostalCode(userCalViewDto.getZipCode());
					if (visnLook != null ) {
							retrievedVisn =  visnLook.getVisnNumber().longValue();
							retrievedZip = visnLook.getPostalCode();
							if (retrievedZip != null && retrievedZip.length() > 0){
								zipCodeFound = true;
							}
							
					}		       
				}
				userCalViewDto.getVisn().setVisnId(retrievedVisn);
			
	
			response = validator.fieldValidations(userCalViewDto, zipCodeFound);
			
			// input validation errors
			if (response.getValidationErrors().size() > 0) {
				response.setFailure(true);
			}
			
	
			//response.setFailure(false);
			
			if (response.isFailure()) {
				log.error(response.getFailureMessage());
				throw new MHVException(response);
			}
			
			
			userCalView = new UserCalViewConverter().convert(userCalViewDto);
			userCalView = userCalViewRepository.save(userCalView);
			
			List<ApiCategory> catgs =apiCategoryRepository.getApiCats();
			
			for(ApiCategory catg:catgs){
				if(catg.getApiCatName().equals("My Tasks")){
					CalViewApiReminder reminder = calViewApiReminderRepository.findByCategoryId(catg.getApiCatId(),userCalView.getUserCalViewId());
					
					if(reminder!= null){
						if(!userCalViewDto.getMyTasks().booleanValue()){
							calViewApiReminderRepository.delete(reminder);
						}
					}else{
						if(userCalViewDto.getMyTasks() != null && userCalViewDto.getMyTasks().booleanValue()){
							calViewApiReminderRepository.save(getCalViewApiReminder(catg,userCalView));
						}
					}
				}
				
				if(catg.getApiCatName().equals("My Recovery Plan Events")){
					CalViewApiReminder reminder = calViewApiReminderRepository.findByCategoryId(catg.getApiCatId(),userCalView.getUserCalViewId());
					
					if(reminder!= null){
						if(!userCalViewDto.getMyRecoveryEvents().booleanValue()){
							calViewApiReminderRepository.delete(reminder);
						}
					}else{
						if(userCalViewDto.getMyRecoveryEvents() != null && userCalViewDto.getMyRecoveryEvents().booleanValue()){
							calViewApiReminderRepository.save(getCalViewApiReminder(catg,userCalView));
						}
					}
				}
			}
			
			
			if (log.isDebugEnabled()) {
				log.debug("SAVE saveUserCalView completed successful...");
			}
			
        } catch (MHVException ex) {
            throw ex;
		} catch(Exception e) {
			String message = "Exception Caught saveUserCalView";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}
		
	}
	
	private CalViewApiReminder getCalViewApiReminder(ApiCategory catg,UserCalView userCalView){
		CalViewApiReminder reminder= new CalViewApiReminder();
		reminder.setApiCatID(catg.getApiCatId());
		reminder.setOplock(0);
		reminder.setUserCalView(userCalView);
		return reminder;
	}
	

	@Override
	public void deleteUserCalView(Long userCalViewId) throws MHVException {
		ResponseUtil <Long> response = new ResponseUtil <Long>();
		
		try {
			userCalViewRepository.delete(userCalViewId);
		} catch(Exception e) {
			String message = "Exception Caught deleteUserCalView";
			log.error(message, e);
			throw new MHVException(message, e);
		}	
	}

		
}

