package gov.va.med.mhv.calendar.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.ToDoTaskConverter;
import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.calendar.model.ToDoTask;
import gov.va.med.mhv.calendar.repository.ToDoTaskRepository;
import gov.va.med.mhv.calendar.service.ToDoTaskService;
import gov.va.med.mhv.calendar.validator.ToDoTaskValidator;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.api.exception.MHVException;

public class ToDoTaskServiceImpl implements ToDoTaskService {
	
	private static Logger log = LogManager.getLogger(ToDoTaskServiceImpl.class);
	
	@Autowired
	private ToDoTaskRepository toDoTaskRepository;
	
	@Autowired
	private ToDoTaskValidator validator;
	
	@Override
	public String test(String sampleText) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<ToDoTaskDTO> getToDosForUser(Long userProfileId)  throws MHVException {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			toDoTasks = toDoTaskRepository.getToDosForUser(userProfileId);
		} catch (Exception e) {
			log.error("Error in fetching getToDosForUser " + e);
			throw new MHVException(e);			
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		
		return toDoTaskDtos;	
	}
	
	
	
	@Override
	public List<ToDoTaskDTO> searchToDosForUser(Long userProfileId,	String keyword) throws MHVException {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			String key="%"+keyword+"%";
			toDoTasks = toDoTaskRepository.searchToDosForUser(userProfileId,key);
		} catch (Exception e) {
			log.error("Error in fetching getToDosForUser " + e);
			throw new MHVException(e);			
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		
		return toDoTaskDtos;	

	}

	
	

	@Override
	public List<ToDoTaskDTO> getFilteredToDosForUser(Long userProfileId, String filter)  throws MHVException  {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			if(filter== null || filter.trim().length()==0 ){
			   toDoTasks = toDoTaskRepository.getToDosForUser(userProfileId);
			}else if(filter.equals("OD")){
				toDoTasks =toDoTaskRepository.getOverdueToDosForUser(userProfileId, "CP");
			}else{
			  toDoTasks = toDoTaskRepository.getFilteredToDosForUser(userProfileId, filter);
			}
			
		} catch (Exception e) {
			log.error("Error in fetching getFilteredToDosForUser " + e);
			throw new MHVException(e);
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		return toDoTaskDtos;
	}

	@Override
	public List<ToDoTaskDTO> getOverdueToDosForUser(Long userProfileId, String filter)  throws MHVException  {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			toDoTasks = toDoTaskRepository.getOverdueToDosForUser(userProfileId,  filter);
			
		} catch (Exception e) {
			log.error("Error in fetching getOverdueToDosForUser " + e);		
			throw new MHVException(e);	
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		return toDoTaskDtos;
	}

	@Override
	public List<ToDoTaskDTO> getAllTaskRemindersByVisn(Long visnId, Date reminderDate)  throws MHVException  {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			toDoTasks = toDoTaskRepository.getAllTaskRemindersByVisn(visnId, reminderDate);
		
		} catch (Exception e) {
			log.error("Error in fetching getAllTaskRemindersByVisn " + e);
			throw new MHVException(e);
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		return toDoTaskDtos;
	}

	@Override
	public List<ToDoTaskDTO> findToDosForUser(Long userProfileId, String keyword) throws MHVException  {
		List<ToDoTaskDTO> toDoTaskDtos = null;
		List<ToDoTask> toDoTasks = null;

		try {
			toDoTasks = toDoTaskRepository.findToDosForUser(userProfileId, keyword);
			
		
		} catch (Exception e) {
			log.error("Error in fetching findToDosForUser " + e);
			throw new MHVException(e);
		}
		
		if(toDoTasks==null || toDoTasks.size()==0) {
			toDoTasks = new ArrayList<ToDoTask>();
		}
		
		toDoTaskDtos = (null != toDoTasks) ? new ToDoTaskConverter().convert(toDoTasks) : null;
		return toDoTaskDtos;
	}

	@Override
	public void saveToDoTask(ToDoTaskDTO toDoTaskDto) throws MHVException  {
		ResponseUtil <ToDoTaskDTO> response = new ResponseUtil <ToDoTaskDTO>();
	
		ToDoTask toDoTask= null;
		
		try {
			response = validator.fieldValidations(toDoTaskDto);
			
			// input validation errors
			if (response.getValidationErrors().size() > 0) {
				response.setFailure(true);
			}
			
			
			if (response.isFailure()) {
				log.error(response.getFailureMessage());
				throw new MHVException(response);
			}
			
			toDoTask = new ToDoTaskConverter().convert(toDoTaskDto);
			toDoTask = toDoTaskRepository.save(toDoTask);
			
			if (log.isDebugEnabled()) {
				log.debug("SAVE TODO TASK completed successful...");
			}
			
        } catch (MHVException ex) {
            throw ex;
		} catch(Exception e) {
			String message = "Exception Caught saveToDoTask";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}
		
	
	}

	@Override
	public void deleteToDoTask(Long toDoTaskId) throws MHVException {
		ResponseUtil <Long> response = new ResponseUtil <Long>();
		
		try {
			toDoTaskRepository.delete(toDoTaskId);
		} catch(Exception e) {
			String message = "Exception Caught deleteToDoTask";
			log.error(message, e);
			throw new MHVException(message, e);
		}
		
	
	}


}
