package gov.va.med.mhv.calendar.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.ReminderConverter;
import gov.va.med.mhv.calendar.dto.ReminderDTO;
import gov.va.med.mhv.calendar.model.Reminder;
import gov.va.med.mhv.calendar.repository.ReminderRepository;
import gov.va.med.mhv.calendar.service.ReminderService;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public class ReminderServiceImpl implements ReminderService {

	private static Logger log = LogManager.getLogger(ReminderServiceImpl.class);
	
	@Autowired
	private ReminderRepository reminderRepository;

	@Override
	public List<ReminderDTO> finderRemindersByUserProfile(Long userProfileId)throws MHVException {
		List<ReminderDTO> reminderDtos = null;
		List<Reminder> reminders = null;
		try {
		
			reminders =reminderRepository.findRemindersByUserProfile(userProfileId);
	
			reminderDtos = (null != reminders) ? new ReminderConverter().convert(reminders) : null; 
		} catch (Exception e) {
			log.error("Error in finderRemindersByUserProfile" + e);
			throw new MHVException(e);
		}			
		return reminderDtos;
	}

	@Override
	public List<ReminderDTO> findRemindersByUserProfileAndSentState(Long userProfileId, Boolean reminderSent) throws MHVException {
		List<ReminderDTO> reminderDtos = null;
		List<Reminder> reminders = null;
		try {
		
			reminders =reminderRepository.findRemindersByUserProfileAndSentState(userProfileId, reminderSent);
	
			reminderDtos = (null != reminders) ? new ReminderConverter().convert(reminders) : null; 
		} catch (Exception e) {
			log.error("Error in finderRemindersByUserProfile" + e);
			throw new MHVException(e);
		}			
		return reminderDtos;
	}

	@Override
	public void saveReminder(ReminderDTO reminderDto) throws MHVException {
		
		ResponseUtil <ReminderDTO> response = new ResponseUtil <ReminderDTO>();
		
		Reminder reminder= null;
		
		try {
		
			response.setFailure(true);
		
			if (response.isFailure()) {
				log.error(response.getFailureMessage());
				throw new MHVException(response);
			}
			
			reminder = new ReminderConverter().convert(reminderDto);
			reminder = reminderRepository.save(reminder);
			
			if (log.isDebugEnabled()) {
				log.debug("saveReminder completed successful...");
			}
			
		} catch (MHVException ex) {
			throw ex;
		} catch(Exception e) {
			String message = "Exception Caught saveReminder";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}		
	}

	@Override
	public void deleteReminder(Long reminderId) throws MHVException {
	ResponseUtil <Long> response = new ResponseUtil <Long>();
		
		try {
			reminderRepository.delete(reminderId);
		} catch(Exception e) {
			String message = "Exception Caught deleteReminder";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}		
	}
	
	

}
