package gov.va.med.mhv.calendar.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.ReminderScheduleConverter;
import gov.va.med.mhv.calendar.dto.ReminderScheduleDTO;
import gov.va.med.mhv.calendar.model.ReminderSchedule;
import gov.va.med.mhv.calendar.repository.ReminderScheduleRepository;
import gov.va.med.mhv.calendar.service.ReminderScheduleService;
import gov.va.med.mhv.common.api.exception.MHVException;

public class ReminderScheduleServiceImpl implements ReminderScheduleService {

	private static Logger log = LogManager.getLogger(ReminderScheduleServiceImpl.class);
	
	@Autowired
	private ReminderScheduleRepository reminderScheduleRepository;
	
	@Override
	public List<ReminderScheduleDTO> findScheduleByName(String name) throws MHVException {
		List<ReminderScheduleDTO> reminderScheduleDtos = null;
		List<ReminderSchedule> reminderSchedules = null;
		try {
		
			reminderSchedules = reminderScheduleRepository.findScheduleByName(name);
			reminderScheduleDtos = (null != reminderSchedules) ? new ReminderScheduleConverter().convert(reminderSchedules) : null; 
		} catch (Exception e) {
			log.error("Error in getScheduledAppointmentRemindersForDateRange" + e);
			throw new MHVException(e);
		}			
		return reminderScheduleDtos;
	}

}
