package gov.va.med.mhv.calendar.service.impl;

import gov.va.med.mhv.calendar.converter.CalViewApiCatConverter;
import gov.va.med.mhv.calendar.converter.CalendarEventConverter;
import gov.va.med.mhv.calendar.converter.UserCalCatConverter;
import gov.va.med.mhv.calendar.dto.ApiCategoryDTO;
import gov.va.med.mhv.calendar.dto.CalViewApiCatDTO;
import gov.va.med.mhv.calendar.dto.CalendarCategoryDTO;
import gov.va.med.mhv.calendar.dto.CalendarEventDTO;
import gov.va.med.mhv.calendar.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.calendar.dto.CategoryDTO;
import gov.va.med.mhv.calendar.dto.UserCalCatDTO;
import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.calendar.model.CalViewApiCat;
import gov.va.med.mhv.calendar.model.CalendarEvent;
import gov.va.med.mhv.calendar.model.UserCalCat;
import gov.va.med.mhv.calendar.repository.CalViewApiCatRepository;
import gov.va.med.mhv.calendar.repository.CalendarEventRepository;
import gov.va.med.mhv.calendar.repository.UserCalCatRepository;
import gov.va.med.mhv.calendar.service.ApiCategoryService;
import gov.va.med.mhv.calendar.service.CalendarCategoryService;
import gov.va.med.mhv.calendar.service.CalendarEventService;
import gov.va.med.mhv.calendar.service.UserCalCatService;
import gov.va.med.mhv.calendar.service.UserCalViewService;
import gov.va.med.mhv.calendar.util.MHVEventComparator;
import gov.va.med.mhv.calendar.validator.CalendarEventValidator;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CalendarEventServiceImpl implements CalendarEventService {

    private static Logger log = LogManager.getLogger(CalendarEventServiceImpl.class);
    
    @Autowired
    private CalendarEventRepository calendarEventRepository;
    
    @Autowired
    private UserCalCatRepository userCalCatRepository;
    
    @Autowired
    private CalViewApiCatRepository calViewApiCatRespository;
    
    @Autowired
    private CalendarEventValidator validator;
    
    @Autowired
    private CalendarCategoryService calendarCategoryService;
    
    @Autowired
    private ApiCategoryService apiCategoryService;
    
    @Autowired
    private UserCalCatService userCalCatService;
    
    @Autowired
    private UserCalViewService userCalViewService;
    
    @Autowired
    private CalendarCategoryService calCategoryService;
    

    
    @Override
    public String test(String sampleText) {
        return sampleText;
    }

    @Override
    public List<CalendarEventDTO> getAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.getAllEventsForUser(calendarSearchCriteriaDto.getUserProfileId(), calendarSearchCriteriaDto.getVisnId(), 
                        calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in getAllEventsForUser" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;
    }
    
// National event
    
    @Override
    public List<CalendarEventDTO> getNationalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.getNationalEventsForUser(calendarSearchCriteriaDto.getUserProfileId(), calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in getNationalEventsForUser" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;
    }
    

    // Regional event
    
        @Override
        public List<CalendarEventDTO> getRegionalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
            List<CalendarEventDTO> calendarEventDtos = null;
            List<CalendarEvent> calendarEvents = null;
            

            try {
                if (null != calendarSearchCriteriaDto) {
                	
                    List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(calendarSearchCriteriaDto.getUserProfileId());
                    
                    Long usrVisnId = userCalViewDtos.get(0).getVisn().getVisnId();

                    calendarEvents = calendarEventRepository.getRegionalEventsForUser(calendarSearchCriteriaDto.getUserProfileId(), calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd(),usrVisnId);
                } else {
                    throw new MHVException("Calendar Search Criteria is null");
                }
                
                calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
            } catch (Exception e) {
                log.error("Error in getRegionalEventsForUser" + e);
                throw new MHVException(e);
            }            
            return calendarEventDtos;
    }
        

	// Generic event
		
		@Override
		public List<CalendarEventDTO> getGenericEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
			List<CalendarEventDTO> calendarEventDtos = null;
			List<CalendarEvent> calendarEvents = null;
			Long usrVisnId  = (long) 0;
			
			try {
				if (null != calendarSearchCriteriaDto) {
                    List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(calendarSearchCriteriaDto.getUserProfileId());
                    
                    if ( null != userCalViewDtos.get(0).getVisn().getVisnId() &&  userCalViewDtos.get(0).getVisn().getVisnId() != 0 ) {
                    
                          usrVisnId = userCalViewDtos.get(0).getVisn().getVisnId();
                    } 
					
                    if(calendarSearchCriteriaDto.getKeyword() != null ){
                    	String keyword ="%"+calendarSearchCriteriaDto.getKeyword()+"%";
    			    	calendarEvents = calendarEventRepository.searchGenericEventsForUser( usrVisnId, calendarSearchCriteriaDto.getSelectedGenericEvent(),keyword );
                    }else{
                    	calendarEvents = calendarEventRepository.getGenericEventsForUser( calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd(), usrVisnId, calendarSearchCriteriaDto.getSelectedGenericEvent() );
                    }
                    
				} else {
					throw new MHVException("Calendar Search Criteria is null");
				}
				
				calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
				
			} catch (Exception e) {
				log.error("Error in getRegionalEventsForUser" + e);
				throw new MHVException(e);
			}			
			
			

			return calendarEventDtos;
    }		

    @Override
    public void saveCalendarEvent(CalendarEventDTO calendarEventDto) throws MHVException {
        
        ResponseUtil <CalendarEventDTO> response = new ResponseUtil <CalendarEventDTO>();
        
        CalendarEvent calendarEvent= null;
        
        try {
            response = validator.fieldValidations(calendarEventDto);
            
            // input validation errors
            if (response.getValidationErrors().size() > 0) {
                response.setFailure(true);
            }
            
            if (response.isFailure()) {
                log.error(response.getFailureMessage());
                throw new MHVException(response);
            }
            
            calendarEvent = new CalendarEventConverter().convert(calendarEventDto);
            
 
            
            calendarEvent = calendarEventRepository.save(calendarEvent);
            
            if (log.isDebugEnabled()) {
                log.debug("SAVE CALENDAR EVENT completed successful...");
            }
            
        } catch (MHVException ex) {
            throw ex;
        } catch(Exception e) {
            String message = "Exception Caught saveCalendarEvent";
            log.error(message, e);
            e.printStackTrace();
            throw new MHVException(message, e);
        }
        
        
        
    }
    


    @Override
    public void deleteCalendarEvent(Long calendarEventId) throws MHVException {
        ResponseUtil <Long> response = new ResponseUtil <Long>();
        
        try {
            calendarEventRepository.delete(calendarEventId);
        } catch(Exception e) {
            String message = "Exception Caught deleteCalendarEvent";
            log.error(message, e);
            e.printStackTrace();
            throw new MHVException(message, e);
        }
    }

    @Override
    public List<CalendarEventDTO> getPersonalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
            	if(calendarSearchCriteriaDto.getKeyword() != null){
            		String keyword ="%"+calendarSearchCriteriaDto.getKeyword()+"%";
            		calendarEvents = calendarEventRepository.searchPersonalEventsForUser(calendarSearchCriteriaDto.getUserProfileId(),keyword );            
            	}else{
            		calendarEvents = calendarEventRepository.getPersonalEventsForUser(calendarSearchCriteriaDto.getUserProfileId(), calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd());
            	}
           	} else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in getPersonalEventsForUser" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;
    }

    @Override
    public List<CalendarEventDTO> getAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.getAllEventsForAdmin(calendarSearchCriteriaDto.getRangeStart(), calendarSearchCriteriaDto.getRangeEnd());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in getAllEventsForAdmin" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;
        }

    @Override
    public List<CalendarEventDTO> getAllVHAReminderEventsByVisn(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.getAllVHAReminderEventsByVisn(calendarSearchCriteriaDto.getVisnId(), calendarSearchCriteriaDto.getReminderDate());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in getAllVHAReminderEventsByVisn" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;        
    }

    @Override
    public List<CalendarEventDTO> findAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.findAllEventsForUser(calendarSearchCriteriaDto.getUserProfileId(), calendarSearchCriteriaDto.getVisnId(), calendarSearchCriteriaDto.getKeyword());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in findAllEventsForUser" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;                
    }

    @Override
    public List<CalendarEventDTO> findAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException {
        List<CalendarEventDTO> calendarEventDtos = null;
        List<CalendarEvent> calendarEvents = null;
        try {
            if (null != calendarSearchCriteriaDto) {
                calendarEvents = calendarEventRepository.findAllEventsForAdmin(calendarSearchCriteriaDto.getKeyword());
            } else {
                throw new MHVException("Calendar Search Criteria is null");
            }
            
            calendarEventDtos = (null != calendarEvents) ? new CalendarEventConverter().convert(calendarEvents) : null; 
        } catch (Exception e) {
            log.error("Error in findAllEventsForAdmin" + e);
            throw new MHVException(e);
        }
        return calendarEventDtos;                
    }

    @Override
    public List<CategoryDTO> getAllCategories(Long userProfileId) throws MHVException {
        
      return null;
        
        
        
    }

    @Override
    public List<CategoryDTO> getCheckedCategories(Long userProfileId) throws MHVException {        
        List<CategoryDTO> catDtos =new ArrayList<CategoryDTO>();
        List<String> checkedCategories = new ArrayList<String>();
        
        try {

            List<CalendarCategoryDTO> calendarCategoryDtos = calendarCategoryService.getAllActiveCategories();
            List<ApiCategoryDTO> apiCatsDtos = apiCategoryService.getApiCats();

            List<UserCalCatDTO> userCalCatsDtos = userCalCatService.getUserCalCatsForUser(userProfileId);
            
            List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(userProfileId);
            
                        
            List<CalViewApiCat> calViewApiCats = calViewApiCatRespository.getCalViewApiCatForUser(userCalViewDtos.get(0).getUserCalViewId());
            List<CalViewApiCatDTO> calViewApiCatsDtos = new CalViewApiCatConverter().convert(calViewApiCats);

        
                for (CalendarCategoryDTO calCat : calendarCategoryDtos) {
                    for (UserCalCatDTO userCalCat : userCalCatsDtos) {
                        if (userCalCat.getCalendarCategory().getCategoryName().equals(calCat.getCategoryName())) {
                            checkedCategories.add(calCat.getCategoryName());
                        break;
                    }
                }

            }
        

                for (ApiCategoryDTO apiCat : apiCatsDtos) {
                    for (CalViewApiCatDTO calViewApiCat : calViewApiCatsDtos) {
                        if (calViewApiCat.getApiCategory().getApiCatName().equals(apiCat.getApiCatName())) {
                            checkedCategories.add(apiCat.getApiCatName());
                    }
                }

            }
            
                
            for (CalendarCategoryDTO calCat : calendarCategoryDtos) {
                CategoryDTO userCalCatDto = new CategoryDTO();
                userCalCatDto.setCategory(calCat.getCategoryName());
                
                if (checkedCategories.contains(calCat.getCategoryName())) {
                    userCalCatDto.setChecked(Boolean.TRUE);
                }
                else {
                    userCalCatDto.setChecked(Boolean.FALSE);
                }
                //userCalCatDto.setUserprofileId(userProfileId);    
                catDtos.add(userCalCatDto);
            }
            
            
            for (ApiCategoryDTO apiCat : apiCatsDtos) {
                CategoryDTO userCalCatDto = new CategoryDTO();
                userCalCatDto.setCategory(apiCat.getApiCatName());
                
                if (checkedCategories.contains(apiCat.getApiCatName())) {
                    userCalCatDto.setChecked(Boolean.TRUE);
                }
                else {
                    userCalCatDto.setChecked(Boolean.FALSE);
                }
                //userCalCatDto.setUserprofileId(userProfileId);    
                catDtos.add(userCalCatDto);
            }
            
            
            CategoryDTO userCalCatDto = new CategoryDTO();
            userCalCatDto.setCategory("Personal Events");
            if (userCalViewDtos.get(0).getPersonalEventFilter()) {
                userCalCatDto.setChecked(Boolean.TRUE);
            }
            else {
                userCalCatDto.setChecked(Boolean.FALSE);

            }
            catDtos.add(userCalCatDto);
        
        } catch (Exception e) {
            String message = "Exception Caught getting checked categories";
            log.error(message, e);
            throw new MHVException(message, e);
        }

        return catDtos;
    }
    
    
    // May need refactoring later
    @Override
    public List<CalendarCategoryDTO> getActiveCategories(Long userProfileId) throws MHVException {        
        List<CalendarCategoryDTO> calendarCategoryDtos =new ArrayList<CalendarCategoryDTO>();
        
        try {

           calendarCategoryDtos = calendarCategoryService.getAllActiveCategories();
            
        } catch (Exception e) {
            String message = "Exception Caught getting checked categories";
            log.error(message, e);
            throw new MHVException(message, e);
        }

        return calendarCategoryDtos;
    }
    
    
    public void saveUserCalCatList(List<CategoryDTO> userCalCatList, Long userProfileId) throws MHVException {
        
        List<CalendarCategoryDTO> calCategoryDtos = calCategoryService.getAllActiveCategories();
        List<ApiCategoryDTO> apiCatsDtos = apiCategoryService.getApiCats();
        ResponseUtil <UserCalViewDTO> response = new ResponseUtil <UserCalViewDTO>();
        deleteCategoriesForView(userProfileId);

        
        if (userCalCatList==null || userCalCatList.size() == 0 || userCalCatList.isEmpty())  {
            List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(userProfileId);
            UserCalViewDTO updatedCalViewDto=userCalViewDtos.get(0);
            updatedCalViewDto.setPersonalEventFilter(Boolean.FALSE);
            userCalViewService.saveUserCalView(updatedCalViewDto);            

        }
        else {

            for (CategoryDTO userCalCatItem : userCalCatList) {
                UserCalCat userCalCat = new UserCalCat();
                CalViewApiCat calViewApiCat = new CalViewApiCat();
                List<UserCalViewDTO> userCalViewDtos = userCalViewService
                        .getUserCalViewForUser(userProfileId);

                for (CalendarCategoryDTO calCatDto : calCategoryDtos) {

                	
                    if (calCatDto.getCategoryName().equals(
                            userCalCatItem.getCategory())) {
                        UserCalViewDTO userCalViewDto = userCalViewDtos.get(0);

                        UserCalCatDTO userCalCatDto = new UserCalCatDTO();
                        userCalCatDto.setUserCalView(userCalViewDto);
                        userCalCatDto.setCalendarCategory(calCatDto);

                        try {

                            response.setFailure(false);

                            if (response.isFailure()) {
                                log.error(response.getFailureMessage());
                                throw new MHVException(response);
                            }

                            userCalCat = new UserCalCatConverter()
                            .convert(userCalCatDto);
                            userCalCat = userCalCatRepository.save(userCalCat);

                            if (log.isDebugEnabled()) {
                                log.debug("SAVE saveUserCalCat completed successful...");
                            }

                        } catch (MHVException ex) {
                            throw ex;
                        } catch (Exception e) {
                            String message = "Exception Caught saveUserCalCat";
                            log.error(message, e);
                            e.printStackTrace();
                            throw new MHVException(message, e);
                        }
                    }

                }

                for (ApiCategoryDTO apiCategoryDto : apiCatsDtos) {

                    if (apiCategoryDto.getApiCatName().equals(
                            userCalCatItem.getCategory())) {

                        CalViewApiCatDTO calViewApiCatDto = new CalViewApiCatDTO();
                        calViewApiCatDto.setApiCategory(apiCategoryDto);
                        calViewApiCatDto.setViewId(userCalViewDtos.get(0)
                                .getUserCalViewId());

                        try {

                            response.setFailure(false);

                            if (response.isFailure()) {
                                log.error(response.getFailureMessage());
                                throw new MHVException(response);
                            }

                            calViewApiCat = new CalViewApiCatConverter().convert(calViewApiCatDto);
                            calViewApiCat = calViewApiCatRespository.save(calViewApiCat);

                            if (log.isDebugEnabled()) {
                                log.debug("SAVE saveUserCalCat completed successful...");
                            }

                        } catch (MHVException ex) {
                            throw ex;
                        } catch (Exception e) {
                            String message = "Exception Caught saveUserCalCat";
                            log.error(message, e);
                            e.printStackTrace();
                            throw new MHVException(message, e);
                        }
                    }

                }

            }

            List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(userProfileId);
            UserCalViewDTO updatedCalViewDto=userCalViewDtos.get(0);
            for (CategoryDTO userCalCatItem: userCalCatList) {
                if (userCalCatItem.getCategory().equalsIgnoreCase("Personal Events")) {
                    if(userCalCatItem.getChecked()) {
                        updatedCalViewDto.setPersonalEventFilter(Boolean.TRUE);
                    }
                    else {
                        updatedCalViewDto.setPersonalEventFilter(Boolean.FALSE);
                    }
                    break;
                }
                
            }
            userCalViewService.saveUserCalView(updatedCalViewDto);

        }
        
    }

    
    @Override
    public void deleteUserCalCat(Long userCalCatId) throws MHVException {
        ResponseUtil <Long> response = new ResponseUtil <Long>();
        
        try {
            userCalCatRepository.delete(userCalCatId);
        } catch(Exception e) {
            String message = "Exception Caught deleteUserCalCat";
            log.error(message, e);
            throw new MHVException(message, e);
        }    
    }

    @Override
    public void deleteCategoriesForView(Long userProfileId) throws MHVException {
        List<UserCalCat> userCalCats= userCalCatRepository.getUserCalCatsForUserProfileId(userProfileId);
        List<UserCalViewDTO> userCalViewDtos = userCalViewService.getUserCalViewForUser(userProfileId);
        List<CalViewApiCat> calViewApiCats = calViewApiCatRespository.getCalViewApiCatForUser(userCalViewDtos.get(0).getUserCalViewId());        
        

        
        UserCalViewDTO updatedCalViewDto=userCalViewDtos.get(0);
        updatedCalViewDto.setPersonalEventFilter(Boolean.FALSE);
        userCalViewService.saveUserCalView(updatedCalViewDto);
        
        //if (userCalCats!=null && userCalCats.size() > 0) {
            try {
                userCalCatRepository.deleteInBatch(userCalCats);
            } catch(Exception e) {
                String message = "Exception Caught deleteCategoriesForView";
                log.error(message, e);
                throw new MHVException(message, e);
            }    
       // }

       // if (calViewApiCats!=null && calViewApiCats.size() > 0) {
            try {
                calViewApiCatRespository.deleteInBatch(calViewApiCats);
            } catch(Exception e) {
                String message = "Exception Caught deleteCategoriesForView";
                log.error(message, e);
                throw new MHVException(message, e);
            }    

        //}

    }

	@Override
	public CalendarEventDTO getPersonalEventById(Long eventId) throws MHVException {
		CalendarEventDTO caleventDto=null;
		try{
		     CalendarEvent calEvent =calendarEventRepository.findOne(eventId);
		     if(calEvent == null){
		    	 throw new MHVException("Event not found");
		     }
		     caleventDto= new CalendarEventConverter().convert(calEvent);
		}catch(Exception e){
            log.error("Error in finding Event by Id",e);
            throw new MHVException(e);
		}
		return caleventDto;
	}
}
