package gov.va.med.mhv.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.CalendarCategoryConverter;
import gov.va.med.mhv.calendar.dto.CalendarCategoryDTO;
import gov.va.med.mhv.calendar.model.CalendarCategory;
import gov.va.med.mhv.calendar.repository.CalendarCategoryRepository;
import gov.va.med.mhv.calendar.service.CalendarCategoryService;
import gov.va.med.mhv.common.api.exception.MHVException;

public class CalendarCategoryServiceImpl implements CalendarCategoryService {
private static Logger log = LogManager.getLogger(CalendarCategoryServiceImpl.class);
	
	@Autowired
	private CalendarCategoryRepository calendarCategoryRepository;
	
	@Override
	public String test(String sampleText) {
		return sampleText;
	}
	
	@Override
	public List<CalendarCategoryDTO> getAllActiveCategories() throws MHVException {
		List<CalendarCategoryDTO> calendarCategoryDtos = null;
		List<CalendarCategory> calendarCategories = null;

		try {
			calendarCategories = calendarCategoryRepository.getAllActiveCategories();
		} catch (Exception e) {
			log.error("Error in fetching all active categories " + e);
			throw new MHVException(e);			
		}
		
		if(calendarCategories==null || calendarCategories.size()==0) {
			calendarCategories = new ArrayList<CalendarCategory>();
		}
		
		calendarCategoryDtos = (null != calendarCategories) ? new CalendarCategoryConverter().convert(calendarCategories) : null;
		
		return calendarCategoryDtos;	
	}

}
