package gov.va.med.mhv.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.ApiCategoryConverter;
import gov.va.med.mhv.calendar.dto.ApiCategoryDTO;
import gov.va.med.mhv.calendar.model.ApiCategory;
import gov.va.med.mhv.calendar.repository.ApiCategoryRepository;
import gov.va.med.mhv.calendar.service.ApiCategoryService;
import gov.va.med.mhv.common.api.exception.MHVException;

public class ApiCategoryServiceImpl implements ApiCategoryService {
private static Logger log = LogManager.getLogger(ApiCategoryServiceImpl.class);
	
	@Autowired
	private ApiCategoryRepository apiCategoryRepository;
	
	@Override
	public String test(String sampleText) {
		return sampleText;
	}

	@Override
	public List<ApiCategoryDTO> getApiCats() throws MHVException {
		List<ApiCategoryDTO> apiCatsDtos = null;
		List<ApiCategory> apiCats = null;

		try {
			apiCats = apiCategoryRepository.getApiCats();
		} catch (Exception e) {
			log.error("Error in fetching all api categories " + e);
			throw new MHVException(e);			
		}
		
		if(apiCats==null || apiCats.size()==0) {
			apiCats = new ArrayList<ApiCategory>();
		}
		
		apiCatsDtos = (null != apiCats) ? new ApiCategoryConverter().convert(apiCats) : null;
		
		return apiCatsDtos;	
	}

	}
	
	


