package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ReminderScheduleDTO;
import gov.va.med.mhv.calendar.model.ReminderSchedule;
import org.springframework.core.convert.converter.Converter;

public class ReminderScheduleConverter implements Converter<ReminderSchedule, ReminderScheduleDTO> {

	@Override
	public ReminderScheduleDTO convert(ReminderSchedule source) {
		ReminderScheduleDTO target = new ReminderScheduleDTO();
		
		target.setId(source.getId());
		target.setName(source.getName());
		target.setReminderScheduleType(new ReminderScheduleTypeConverter().convert(source.getReminderScheduleType()));
		
		return target;
		
	}
		public ReminderSchedule convert(ReminderScheduleDTO source) {
		ReminderSchedule target = new ReminderSchedule();
		
		target.setId(source.getId());
		target.setName(source.getName());
		target.setReminderScheduleType(new ReminderScheduleTypeConverter().convert(source.getReminderScheduleType()));
		
		return target;
		
	}
		
		public List<ReminderScheduleDTO> convert(List<ReminderSchedule> source) {
			List <ReminderScheduleDTO> reminderScheduleDto= null;
			if(null !=source) {
				reminderScheduleDto = new ArrayList<ReminderScheduleDTO>();

				for (ReminderSchedule reminderSchedule: source) {
					reminderScheduleDto.add(this.convert(reminderSchedule));
				}

			}

			return reminderScheduleDto;
		}

}
