package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ReminderDTO;
import gov.va.med.mhv.calendar.model.Reminder;
import org.springframework.core.convert.converter.Converter;

public class ReminderConverter implements Converter<Reminder, ReminderDTO> {

	@Override
	public ReminderDTO convert(Reminder source) {
		ReminderDTO target = new ReminderDTO();
		
		target.setId(source.getId());
		target.setReminderSent(source.getReminderSent());
		target.setUserProfileId(source.getUserProfileId());
		
		return target;
	}
	
	public Reminder convert(ReminderDTO source) {
		Reminder target = new Reminder();
		
		target.setId(source.getId());
		target.setReminderSent(source.getReminderSent());
		target.setUserProfileId(source.getUserProfileId());
		
		return target;
	}
	
	public List<ReminderDTO> convert(List<Reminder> source) {
		List <ReminderDTO> reminderDto= null;
		if(null !=source) {
			reminderDto = new ArrayList<ReminderDTO>();

			for (Reminder reminder: source) {
				reminderDto.add(this.convert(reminder));
			}

		}

		return reminderDto;
	}

}
