/**
 * 
 */
package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.CalViewApiCatDTO;
import gov.va.med.mhv.calendar.model.CalViewApiCat;

import org.springframework.core.convert.converter.Converter;


public class CalViewApiCatConverter implements Converter<CalViewApiCat, CalViewApiCatDTO> {

	@Override
	public CalViewApiCatDTO convert(CalViewApiCat source) {
		CalViewApiCatDTO calViewApiCat = new CalViewApiCatDTO();
		calViewApiCat.setViewApiCatId(source.getViewApiCatId());
		calViewApiCat.setApiCategory(new ApiCategoryConverter().convert(source.getApiCategory()));
		calViewApiCat.setViewId(source.getViewId());
		return calViewApiCat;
	}
	
	public CalViewApiCat convert(CalViewApiCatDTO source) {
		CalViewApiCat calViewApiCat = new CalViewApiCat();
		calViewApiCat.setViewApiCatId(source.getViewApiCatId());
		calViewApiCat.setApiCategory(new ApiCategoryConverter().convert(source.getApiCategory()));
		calViewApiCat.setViewId(source.getViewId());
		return calViewApiCat;
	}
	
	public List<CalViewApiCatDTO> convert(List<CalViewApiCat> source) {
		List <CalViewApiCatDTO> calViewApiCatDto= null;
		if(null !=source) {
			calViewApiCatDto = new ArrayList<CalViewApiCatDTO>();

			for (CalViewApiCat calViewApi: source) {
				calViewApiCatDto.add(this.convert(calViewApi));
			}

		}

		return calViewApiCatDto;
	}
	
}
