package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.AppointmentReminderDetailsDTO;
import gov.va.med.mhv.calendar.model.AppointmentReminderDetails;
import org.springframework.core.convert.converter.Converter;

public class AppointmentReminderDetailsConverter implements Converter<AppointmentReminderDetails, AppointmentReminderDetailsDTO> {

	@Override
	public AppointmentReminderDetailsDTO convert(AppointmentReminderDetails source) {
		AppointmentReminderDetailsDTO target = new AppointmentReminderDetailsDTO();
		target.setId(source.getId());
		target.setIen(source.getIen());
	
		return target;
	}
	public AppointmentReminderDetails convert(AppointmentReminderDetailsDTO source) {
		AppointmentReminderDetails target = new AppointmentReminderDetails();
		target.setId(source.getId());
		target.setIen(source.getIen());
	
		return target;
	}
	
	public List<AppointmentReminderDetailsDTO> convert(List<AppointmentReminderDetails> source) {
		List <AppointmentReminderDetailsDTO> appointmentReminderDetailsDto= null;
		if(null !=source) {
			appointmentReminderDetailsDto = new ArrayList<AppointmentReminderDetailsDTO>();

			for (AppointmentReminderDetails reminderDetails: source) {
				appointmentReminderDetailsDto.add(this.convert(reminderDetails));
			}

		}

		return appointmentReminderDetailsDto;
	}

}
