package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.AppointmentReminderDTO;
import gov.va.med.mhv.calendar.model.AppointmentReminder;
import org.springframework.core.convert.converter.Converter;

public class AppointmentReminderConverter implements Converter<AppointmentReminder, AppointmentReminderDTO> {

	@Override
	public AppointmentReminderDTO convert(AppointmentReminder source) {
		AppointmentReminderDTO target = new AppointmentReminderDTO();
		
		target.setId(source.getId());
		target.setReminderState(source.getReminderState());
		target.setPatientId(source.getPatientId());
		
		return target;
	}
	
	public AppointmentReminder convert(AppointmentReminderDTO source) {
		AppointmentReminder target = new AppointmentReminder();
		
		target.setId(source.getId());
		target.setReminderState(source.getReminderState());
		target.setPatientId(source.getPatientId());
		
		return target;
	}
	
	public List<AppointmentReminderDTO> convert(List<AppointmentReminder> source) {
		List <AppointmentReminderDTO> appointmentReminderDto= null;
		if(null !=source) {
			appointmentReminderDto = new ArrayList<AppointmentReminderDTO>();

			for (AppointmentReminder appointmentReminder: source) {
				appointmentReminderDto.add(this.convert(appointmentReminder));
			}

		}

		return appointmentReminderDto;
	}
	

}
