package gov.va.med.mhv.calendar.repository;

import gov.va.med.mhv.calendar.model.CalViewApiReminder;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CalViewApiReminderRepository extends JpaRepository<CalViewApiReminder, Long> {

	@Query("select calViewReminder from CalViewApiReminder calViewReminder where calViewReminder.userCalView.userCalViewId = :viewId ")
	public List<CalViewApiReminder> getUsersCalViewApiReminderForUser(@Param("viewId") Long viewId);

	
	@Query("select calViewReminder from CalViewApiReminder calViewReminder ")
	public List<CalViewApiReminder> getCalViewApiReminderForUser();
	
	
	@Query("select calViewReminder from CalViewApiReminder calViewReminder  where calViewReminder.apiCatID=:catId and calViewReminder.userCalView.userCalViewId=:viewId")
	public CalViewApiReminder findByCategoryId(@Param("catId") Long catId,@Param("viewId") Long viewId);


}
