package gov.va.med.mhv.calendar.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;


@Entity
@Table(name = "REMINDER")
public class Reminder implements Serializable {

	private static final long serialVersionUID = -8738532950194294627L;

	@Id
	@Column(name = "REMINDER_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "REMINDER_SENT", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean reminderSent;

	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getReminderSent() {
		return reminderSent;
	}

	public void setReminderSent(Boolean reminderSent) {
		this.reminderSent = reminderSent;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
}
