package gov.va.med.mhv.calendar.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.Type;

@Entity
@Table(name = "CAL_EVENTS")
public class CalendarEvent implements Serializable {

	private static final long serialVersionUID = 5349491839984745455L;

	@Id
	@Column(name = "EVENT_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long eventId;
	
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "TIME_ZONE")
	private String timeZone;
	
	@Column(name = "START_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date startDate;
	
	@Column(name = "REMINDER_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reminderDate;
	
	@Column(name = "LINK")
	private String link;
	
	@Column(name = "RECUR_UNTIL_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date recurUntilDate;
	
	@Column(name = "REMINDER_INTERVAL")
	private String reminderInterval;
	
	@Column(name = "ALL_DAY", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean allDay;
	
	@Column(name = "VHA_GLOBAL_EVENT", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean vhaEvent;
	
	@Column(name = "DESCRIPTION")
	private String description;
	
	@Column(name = "RECURRENCE_INTERVAL")
	private String recurrenceInterval;
	
	@Column(name = "END_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date endDate;
	
	@Column(name = "SUBJECT")
	private String subject;
	
	@Column(name = "LOCATION")
	private String location;
	
	@Column(name = "API_EVENT_KEY")
	private Long apiEventKey;
	
	@Column(name = "REPEATING", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean repeating;
	
	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;
	
	/*@Column(name = "CAL_EVNT_CAT_CAL_CAT_ID")
	private Long calendarCategoryId;*/
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "CAL_EVNT_CAT_CAL_CAT_ID")
	private CalendarCategory calendarCategory;

	/*@Column(name = "VISN_VISN_ID")
	private Long visnId;*/
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VISN_VISN_ID")
	private Visn visn;

	public Long getEventId() {
		return eventId;
	}

	public void setEventId(Long eventId) {
		this.eventId = eventId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getTimeZone() {
		return timeZone;
	}

	public void setTimeZone(String timeZone) {
		this.timeZone = timeZone;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getReminderDate() {
		return reminderDate;
	}

	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}

	public String getLink() {
		return link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public Date getRecurUntilDate() {
		return recurUntilDate;
	}

	public void setRecurUntilDate(Date recurUntilDate) {
		this.recurUntilDate = recurUntilDate;
	}

	public String getReminderInterval() {
		return reminderInterval;
	}

	public void setReminderInterval(String reminderInterval) {
		this.reminderInterval = reminderInterval;
	}

	public Boolean getAllDay() {
		return allDay;
	}

	public void setAllDay(Boolean allDay) {
		this.allDay = allDay;
	}

	public Boolean getVhaEvent() {
		return vhaEvent;
	}

	public void setVhaEvent(Boolean vhaEvent) {
		this.vhaEvent = vhaEvent;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRecurrenceInterval() {
		return recurrenceInterval;
	}

	public void setRecurrenceInterval(String recurrenceInterval) {
		this.recurrenceInterval = recurrenceInterval;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public Long getApiEventKey() {
		return apiEventKey;
	}

	public void setApiEventKey(Long apiEventKey) {
		this.apiEventKey = apiEventKey;
	}

	public Boolean getRepeating() {
		return repeating;
	}

	public void setRepeating(Boolean repeating) {
		this.repeating = repeating;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	/*public Long getCalendarCategoryId() {
		return calendarCategoryId;
	}

	public void setCalendarCategoryId(Long calendarCategoryId) {
		this.calendarCategoryId = calendarCategoryId;
	}*/

	public CalendarCategory getCalendarCategory() {
		return calendarCategory;
	}

	public void setCalendarCategory(CalendarCategory calendarCategory) {
		this.calendarCategory = calendarCategory;
	}  

	/*public Long getVisnId() {
		return visnId;
	}

	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}*/

	public Visn getVisn() {
		return visn;
	}

	public void setVisn(Visn visn) {
		this.visn = visn;
	}  
	
	
}
