package gov.va.med.mhv.calendar.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "PHR_APPOINTMENT_REMINDER")
public class AppointmentReminder implements Serializable {

	private static final long serialVersionUID = -1050756773521965964L;

	@Id
	@Column(name = "PHR_APPOINTMENT_REMINDER_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "REMINDER_STATE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean reminderState;
	
	@Column(name = "PATIENT_ID")
	private Integer patientId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getReminderState() {
		return reminderState;
	}

	public void setReminderState(Boolean reminderState) {
		this.reminderState = reminderState;
	}

	public Integer getPatientId() {
		return patientId;
	}

	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}
}
