package gov.va.med.mhv.calendar.util;

import gov.va.med.mhv.calendar.dto.MHVEventModel;

import java.util.Comparator;

import org.apache.commons.lang3.builder.CompareToBuilder;

public class MHVEventComparator implements Comparator<MHVEventModel> {

	@Override
	public int compare(MHVEventModel obj, MHVEventModel other) {

		if (obj!=null && other!=null) {

			if (obj.getStartDate() !=null && other.getStartDate()!=null && obj.getEndDate()==null && other.getEndDate()==null) {
				return new CompareToBuilder()

				.append(other.getDisplayEventListDate(), obj.getDisplayEventListDate())
				.append(obj.getEventName(), other.getEventName()).toComparison();
			}
			else {

				if (obj.getEndDate() !=null && other.getEndDate()!=null) {
					return new CompareToBuilder()
					.append(other.getDisplayEventListDate(), obj.getDisplayEventListDate())
					.append(obj.getEventName(), other.getEventName()).toComparison();

				}

			}

		}
		return 0;

	}
}
