package gov.va.med.mhv.calendar.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/")
@Service("userCalViewService")
public interface UserCalViewService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getUsersForVhaReminderByVisn/{visnId}")
	public List<UserCalViewDTO> getUsersForVhaReminderByVisn(@PathParam("visnId") Long visnId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getUserCalViewForUser/{userProfileId}")
	public List<UserCalViewDTO> getUserCalViewForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveUserCalView")
	public void saveUserCalView(UserCalViewDTO userCalViewDto) throws MHVException;
	
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteUserCalView/{userCalViewId}")
	public void deleteUserCalView(@PathParam("userCalViewId") Long userCalViewId) throws MHVException;	
	
}
