package gov.va.med.mhv.calendar.service;

import java.util.Date;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/")
@Service("toDoTaskService")
public interface ToDoTaskService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);
	

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getToDosForUser/{userProfileId}")
	public List<ToDoTaskDTO> getToDosForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/searchToDosForUser/{userProfileId}/{keyword}")
	public List<ToDoTaskDTO> searchToDosForUser(@PathParam("userProfileId") Long userProfileId,@PathParam("keyword") String keyword) throws MHVException;
	
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getFilteredToDosForUser/{userProfileId}/{filter}")
	public List<ToDoTaskDTO> getFilteredToDosForUser(@PathParam("userProfileId") Long userProfileId, @PathParam("filter") String filter) throws MHVException;
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getOverdueToDosForUser/{userProfileId}/{filter}")
	public List<ToDoTaskDTO> getOverdueToDosForUser(@PathParam("userProfileId") Long userProfileId, @PathParam("filter") String filter) throws MHVException;
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getAllTaskRemindersByVisn/{visnId}/{reminderDate}")
	public List<ToDoTaskDTO> getAllTaskRemindersByVisn(@PathParam("visnId") Long visnId, @PathParam("reminderDate") Date reminderDate) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/findToDosForUser/{userProfileId}/{keyword}")
	public List<ToDoTaskDTO> findToDosForUser(@PathParam("userProfileId") Long userProfileId, @PathParam("keyword") String keyword) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveToDo")
	public void saveToDoTask(ToDoTaskDTO toDoTaskDTO) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteToDoTask/{toDoTaskId}")
	public void deleteToDoTask(@PathParam("toDoTaskId") Long toDoTaskId) throws MHVException;	

}
