package gov.va.med.mhv.calendar.service;

import gov.va.med.mhv.calendar.dto.CalendarCategoryDTO;
import gov.va.med.mhv.calendar.dto.CalendarEventDTO;
import gov.va.med.mhv.calendar.dto.CategoryDTO;
import gov.va.med.mhv.calendar.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.calendar.dto.MHVEventModel;
import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Path("/")
@Service("calendarService")
public interface CalendarService {
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/findEventsForUser")
	public List<MHVEventModel> findEventsForUser(CalendarSearchCriteriaDTO searchCriteria) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/searchEventsForUser")
	public List<MHVEventModel> searchEventsForUser(CalendarSearchCriteriaDTO searchCriteria) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getToDosForUser/{userProfileId}")
	public List<ToDoTaskDTO> getToDosForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveToDo")
	public void saveToDoTask(ToDoTaskDTO toDoTaskDTO) throws MHVException;
	
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteToDoTask/{toDoTaskId}")
	public void deleteToDoTask(@PathParam("toDoTaskId") Long toDoTaskId) throws MHVException;	
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetAllCategories/{userProfileId}")
	public List<CategoryDTO> getAllCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetAllActiveCategories/{userProfileId}")
	public List<CalendarCategoryDTO> getAllActiveCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetCheckedCategories/{userProfileId}")
	public List<CategoryDTO> getCheckedCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveCalendarEvent")
	public void saveCalendarEvent(CalendarEventDTO calendarEventDto) throws MHVException;
	
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteCalendarEvent/{calendarEventId}")
	public void deleteCalendarEvent(@PathParam("calendarEventId") Long calendarEventId) throws MHVException;	
	
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveUserCalCatList/{userProfileId}")
	public void saveUserCalCatList(List<CategoryDTO> userCalCatList, @PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getUserCalViewForUser/{userProfileId}")
	public UserCalViewDTO getUserCalViewForUser(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveUserCalView")
	public void saveUserCalView(UserCalViewDTO userCalViewDto) throws MHVException;
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/getFilteredToDosForUser/{userProfileId}/{filter}")
	public List<ToDoTaskDTO> getFilteredToDosForUser(@PathParam("userProfileId") Long userProfileId, @PathParam("filter") String filter) throws MHVException;
	
	
	
	@GET
	@Produces(MediaType.WILDCARD)
	@Consumes(MediaType.WILDCARD)
	@Path("external/stream/report/{userProfileId}/{rangeStart}/{rangeEnd}/{patientId}/{eventTypes}")
	public Response generateReport(@PathParam("userProfileId") Long userProfileId,@PathParam("rangeStart") String rangeStart, @PathParam("rangeEnd") String rangeEnd,@PathParam("patientId") String patientId,@PathParam("eventTypes") String eventTypes) ;


	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("personalEventById/{eventId}")
	public MHVEventModel getPersonalEventById(@PathParam("eventId") Long eventId) throws MHVException;

}
