package gov.va.med.mhv.calendar.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.calendar.dto.CalendarCategoryDTO;
import gov.va.med.mhv.calendar.dto.CalendarEventDTO;
import gov.va.med.mhv.calendar.dto.CalendarSearchCriteriaDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.calendar.dto.CategoryDTO;

@Path("/")
@Service("calendarEventService")
public interface CalendarEventService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("caleventsforuser")
	public List<CalendarEventDTO> getAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;

	// National Events service
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("nationaleventsforuser")
	public List<CalendarEventDTO> getNationalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	// Regional Events service
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("regionaleventsforuser")
	public List<CalendarEventDTO> getRegionalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;

	// Generic Events service
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("genericeventsforuser")
	public List<CalendarEventDTO> getGenericEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/saveCalendarEvent")
	public void saveCalendarEvent(CalendarEventDTO calendarEventDto) throws MHVException;
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteCalendarEvent/{calendarEventId}")
	public void deleteCalendarEvent(@PathParam("calendarEventId") Long calendarEventId) throws MHVException;	
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calpersonaleventsforuser")
	public List<CalendarEventDTO> getPersonalEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calalleventsforadmin")
	public List<CalendarEventDTO> getAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calalleventsforadmin")
	public List<CalendarEventDTO> getAllVHAReminderEventsByVisn(CalendarSearchCriteriaDTO calendarSearchCriteriaDto)	throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calfindalleventsforuser")
	public List<CalendarEventDTO> findAllEventsForUser(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calfindalleventsforadmin")
	public List<CalendarEventDTO> findAllEventsForAdmin(CalendarSearchCriteriaDTO calendarSearchCriteriaDto) throws MHVException;
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetAllCategories/{userProfileId}")
	public List<CategoryDTO> getAllCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetCheckedCategories/{userProfileId}")
	public List<CategoryDTO> getCheckedCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("calgetActiveCategories/{userProfileId}")
	public List<CalendarCategoryDTO> getActiveCategories(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@POST
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    @Path("/saveUserCalCatList/{userProfileId}")
    public void saveUserCalCatList(List<CategoryDTO> userCalCatList, @PathParam("userProfileId") Long userProfileId) throws MHVException;

	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteUserCalCat/{userCalCatId}")
	public void deleteUserCalCat(@PathParam("userCalCatId") Long userCalCatId) throws MHVException;	
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/deleteCategoriesForView/{userProfileId}")
	public void deleteCategoriesForView(@PathParam("userProfileId") Long userProfileId) throws MHVException;	
	
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("personalEventById/{eventId}")
	public CalendarEventDTO getPersonalEventById(@PathParam("eventId") Long eventId) throws MHVException;
	
	
}
