package gov.va.med.mhv.calendar.dto;

import gov.va.med.mhv.calendar.util.CommonUtility;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class ToDoTaskDTO implements Serializable{

	private static final long serialVersionUID = 4399995997664470944L;

	private Long toDoId;

	private String subject;

	private String description;

	private Date dueDate;

	private String reminderInterval;

	private Date reminderDate;

	private String toDoStatus;

	private Long userProfileId;
	
	

	@JsonIgnore
	public String getDisplayStatus() {
		String displayStatus=null;
		if(toDoStatus.equals("NS")){
			displayStatus="Not Started";
		}else if(toDoStatus.equals("IP")){
			displayStatus="In Progress";
		}else if(toDoStatus.equals("CP")){
			displayStatus="Completed";
		}else if(toDoStatus.equals("DF")){
			displayStatus="Deferred";
		}
		return displayStatus;
	}
	
	@JsonIgnore
	public String getDisplayDueDate() {
		return (getDueDate() != null) ? CommonUtility.dateToString(getDueDate(), "MM/dd/yyyy") : null; 
	}




	public Long getToDoId() {
		return toDoId;
	}


	public void setToDoId(Long toDoId) {
		this.toDoId = toDoId;
	}


	public String getSubject() {
		return subject;
	}


	public void setSubject(String subject) {
		this.subject = subject;
	}


	public String getDescription() {
		return description;
	}


	public void setDescription(String description) {
		this.description = description;
	}


	public Date getDueDate() {
		return dueDate;
	}


	public void setDueDate(Date dueDate) {
		this.dueDate = dueDate;
	}


	public String getReminderInterval() {
		return reminderInterval;
	}


	public void setReminderInterval(String reminderInterval) {
		this.reminderInterval = reminderInterval;
	}


	public Date getReminderDate() {
		return reminderDate;
	}


	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}


	public String getToDoStatus() {
		return toDoStatus;
	}


	public void setToDoStatus(String toDoStatus) {
		this.toDoStatus = toDoStatus;
	}


	public Long getUserProfileId() {
		return userProfileId;
	}


	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}


}
