package gov.va.med.mhv.bluebutton.web.util;

import java.util.HashMap;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.util.PortalUtil;

public class ModePhaseListener implements PhaseListener {
	private static Logger LOG = LogManager.getLogger(ModePhaseListener.class);
	
	private static final long serialVersionUID = -5701215610867004256L;

	private static final Map<String,String> FORWARDS = new HashMap<String, String>();
	
	static {
		FORWARDS.put("healthsummary","healthsummary/healthSummary");
		//ADD OTHERS HERE...
	}
	
	@Override
	public PhaseId getPhaseId() {
		return PhaseId.RESTORE_VIEW;
	}

	@Override
	public void beforePhase(PhaseEvent event) {
		// TODO Auto-generated method stub
	}

	@Override
	public void afterPhase(PhaseEvent event) {
		PhaseId phaseid = event.getPhaseId();
		if (phaseid == PhaseId.RESTORE_VIEW) {
			String mode = getRequestParameter("mode");
			if(LOG.isDebugEnabled()) {
				if( mode != null ) {
					LOG.debug("Mode discovered from parameter: "+mode);
				}
			}
			if (FORWARDS.containsKey(mode)) {
				FacesContext facesContext = event.getFacesContext();
				facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, null, FORWARDS.get(mode));
			}
		}
	}
	
	private String getRequestParameter(String paramKey) {
		try {
			Object o = FacesContext.getCurrentInstance().getExternalContext().getRequest();
            HttpServletRequest httpReq = null;
            if (o instanceof javax.portlet.RenderRequest) {
                    javax.portlet.RenderRequest request = (javax.portlet.RenderRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            } else if (o instanceof javax.portlet.ResourceRequest) {
                    javax.portlet.ResourceRequest request = (javax.portlet.ResourceRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            } else if (o instanceof javax.portlet.ActionRequest) {
                    javax.portlet.ActionRequest request = (javax.portlet.ActionRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            }

            return (httpReq.getParameter(paramKey));
		}
		catch(Exception e) {
			LOG.error("Unable to extract request parameter '"+paramKey+"'");
		}
		
		return "";
	}

}
