package gov.va.med.mhv.bluebutton.web.controller;

import gov.va.med.mhv.bluebutton.web.bean.FieldTestBean;
import gov.va.med.mhv.bluebutton.web.bean.MainViewBean;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.FieldTestEnum;
import gov.va.med.mhv.common.api.enumeration.UserTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.Serializable;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean(name="selectReportController")
@Component
@Scope("request")
public class SelectReportController extends AbstractPhrController implements Serializable {
	private static final long serialVersionUID = -938373218164649136L;

	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	private static final String USER_ROLE_KEY = "LIFERAY_SHARED_accountType";

	private static Logger logger = LogManager.getLogger(SelectReportController.class);

	@Autowired
	private MainViewBean view;

	@Autowired
	private FieldTestBean fieldTest;
	
	@Resource
	private UserMgmtService userMgmtServiceProxy;
	
	Boolean isBasicUser = null;
	Boolean isAdvancedUser = null;
	Boolean isPremiumUser = null;
	Boolean isVACCDDirectFieldTestUser = null;
	Boolean isBBMIFieldTestUser = null;
	
	public void init(ComponentSystemEvent event) {
		
		try {
			
			getIsBasicUser();
			getIsAdvancedUser();
			getIsPremiumUser();
			getIsVACCDDirectFieldTestUser();
			getIsBBMIFieldTestUser();
				
		} catch (MHVException e) {
			if(logger.isErrorEnabled()) {
				logger.error(e);
			}
		}
		
	}
	
	public Boolean getIsBasicUser() throws MHVException {
		if (isBasicUser == null) {
			isBasicUser = new Boolean(UserTypeEnum.isBasic(getUserRoleFromSession()));
		}
		return isBasicUser;
	}
	
	public Boolean getIsAdvancedUser() throws MHVException {
		if (isAdvancedUser == null) {
			isAdvancedUser = new Boolean(UserTypeEnum.isAdvanced(getUserRoleFromSession()));
		}
		return isAdvancedUser;
	}

	public Boolean getIsPremiumUser() throws MHVException {
		if (isPremiumUser == null) {
			isPremiumUser = new Boolean(UserTypeEnum.isPremium(getUserRoleFromSession()));
		}
		return isPremiumUser;
	}
	
	public Boolean getIsVACCDDirectFieldTestUser() {
		if (isVACCDDirectFieldTestUser == null) {
			isVACCDDirectFieldTestUser = new Boolean(testFieldTestGroup(FieldTestEnum.VACCDDIRECT_FIELD_TESTER));
		}
		return isVACCDDirectFieldTestUser;
	}
	
	public Boolean getIsBBMIFieldTestUser() { 
		if (isBBMIFieldTestUser == null) {
			isBBMIFieldTestUser = new Boolean(testFieldTestGroup(FieldTestEnum.BBMI_FIELD_TESTER));
		}
		return isBBMIFieldTestUser;
	}
	
	
	public Boolean testFieldTestGroup( FieldTestEnum fte) {
		Boolean result = false;
		
		if( fte.getNational() ) {
			return true;
		} else if( fieldTest.getInitialized() ) {
			return fieldTest.getFieldTestList().contains(fte);
		} else {
			try {
				List<FieldTestDTO> dtos = userMgmtServiceProxy.getFieldTestGroupsByUserName(getUserProfileDTOFromSession().getUserName());
				
				List<String> names = FieldTestEnum.toNameList();

				for( FieldTestDTO d: dtos) {
					
					if( d.getName().equals(fte.getName())) {
							result = true;
					}
					//MERGE ALL THE NATIONAL STATUS FOR KNOWN FEATURES
					//AND LOCAL SESSION INSTANCE CONTAINING ALL THIS USERS FIELD TEST GROUPS
					if( names.contains(d.getName()) ) {
						FieldTestEnum e = FieldTestEnum.valueOfByName(d.getName());
						if( d.getIsNational() && !e.getNational() ) {
							e.setNational(true);
						}
						fieldTest.getFieldTestList().add(e);
						if(logger.isDebugEnabled()) {
							logger.debug("Added feature "+ d.getName() +" for role: '" + d.getRole() +"' "+ (e.getNational()?"(National)":"(Field Tester)"));
						}
					}
					
				}
				
//				if(logger.isDebugEnabled()) {
//					if (fieldTest.getFieldTestList().size() == 0) {
//						logger.debug("User Account:  Has no field tester roles.");
//					}
//				}
				
				//Prevents the fieldTest list from being loaded more than once per session
				fieldTest.setInitialized(true);
			} catch (MHVException e) {
				if(logger.isErrorEnabled()) {
					logger.error(e);
				}
			}
		}
		return result;
	}
	
	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			
			String patientStr =  (String)session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(patientStr, UserProfileDTO.class);
			
		} catch(Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}
	
	protected UserTypeEnum getUserRoleFromSession() throws MHVException {
		UserTypeEnum userRole;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			
			String userRoleStr =  (String)session.getAttribute(USER_ROLE_KEY, PortletSession.APPLICATION_SCOPE);
			userRole = UserTypeEnum.valueOfByRole(userRoleStr);
			
		} catch(Exception e) {
			throw new MHVException("Unable to get user role from session");
		}
		return userRole;
	}

	public String show() {
		
		// SETUP THE DEFAULT SUB-VIEW FOR EACH MAIN VIEW
		switch (view.getSelectMode()) {
			case MV_DOWNLOAD_MY_DATA:
				return "download/downloadMyData";
			case MV_IMAGES:
				return "imaging/medicalImagesAndReports";
			case MV_HEALTH_SUMMARY:
				return "healthsummary/healthSummary";
			default:
				break;
		}
		
		return null;
	}
}