package gov.va.med.mhv.bluebutton.web.controller;

import gov.va.med.mhv.bluebutton.transfer.HealthSummaryDTO;
import gov.va.med.mhv.bluebutton.web.ViewMode;
import gov.va.med.mhv.bluebutton.web.bean.HealthSummaryListBean;
import gov.va.med.mhv.bluebutton.web.bean.MainViewBean;
import gov.va.med.mhv.bluebutton.web.bean.OsccdServiceStatusBean;
import gov.va.med.mhv.bluebutton.web.bean.SendHealthSummaryFormBean;
import gov.va.med.mhv.bluebutton.web.bean.VaDirectServiceStatusBean;
import gov.va.med.mhv.bluebutton.web.util.PdfXHTMLWrapper;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.osccd.client.BlueButtonRepository;
import gov.va.med.mhv.osccd.client.C32Document;
import gov.va.med.mhv.osccd.client.DocStatus;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.DirectMessageService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.lowagie.text.DocumentException;

@ManagedBean(name="healthSummaryController")
@Component
@Scope("request")
@PropertySource("classpath:${MHV_ENV_PROPERTY}.bluebutton.portlet.properties")


public class HealthSummaryController extends AbstractHealthSummaryController {
	private static Logger logger = LogManager.getLogger(HealthSummaryController.class);
	
	private static final long serialVersionUID = 1666585717133300076L;

	@Autowired
	private MainViewBean view;

	@Autowired
	private HealthSummaryListBean healthSummaries;
	
	@Autowired
	protected OsccdServiceStatusBean status;
	
	@Autowired
	protected VaDirectServiceStatusBean directStatus;
	
	@Autowired
	private SendHealthSummaryFormBean sendHealthSummaryForm;
	
	@Resource(name = "activityProxy")
	private AccountActivityCreatorService activityProxy;

	@Resource
	private BlueButtonRepository bbRepositoryfactory;
	
	@Resource
    private DirectMessageService directMessageServiceProxy;
	
	@Value("${direct.mailbox}")
    private String directMailbox;

   @Value("${direct.messageurl}")
    private String directMessageurl;
    
    @Value("${direct.messagepath}")
    private String directMessagepath;
    
    @Value("${direct.sendurl}")
    private String directSendurl;
    
    @Value("${direct.sendpath}")
    private String directSendpath;
    
    @Value("${direct.privatekey}")
    private String directPrivatekey;
    
    @Value("${direct.publickey}")
    private String directPublickey;
    
    @Value("${direct.messagesubject}")
    private String directMessageSubject;
    
    @Value("${direct.messagefrom}")
    private String directMessageFrom;
    
    @Value("${direct.messagebody}")
    private String directMessageBody;
    
    @Value("${direct.perproviderperday}")
    private String directPerProviderPerDay;
    
    @Value("${direct.perday}")
    private String directPerDay;

	
	private static Map<String, Templates> CACHE = new Hashtable<String, Templates>();
    // map of Templates objects
	private Transformer transformer; 
	
	public static final String CCD_VIA_DIRECT_SUCCESS = "success";
	public static final String CCD_VIA_DIRECT_FAIL = "failure";
	public static final String CCD_VIA_DIRECT_INVALID_DIRECT_ADDR = "invalid";
	
	public void init(ComponentSystemEvent event) {
		if (logger.isDebugEnabled()) {
			logger.debug("init():  directStatus.getIsDisclaimerError() = " + directStatus.getIsDisclaimerError()) ;
			logger.debug("init():  directStatus.getIsEmailFormatError() = " + directStatus.getIsEmailFormatError()) ;
			logger.debug("init():  directStatus.getIsEmailMatchError() = " + directStatus.getIsEmailMatchError()) ;
			logger.debug("init():  directStatus.getIsEmailRequiredError() = " + directStatus.getIsEmailRequiredError()) ;
			logger.debug("init():  directStatus.getIsInvalidProviderError() = " + directStatus.getIsInvalidProviderError()) ;
			logger.debug("init():  directStatus.getIsTwiceTodayError() = " + directStatus.getIsTwiceTodayError()) ;
			logger.debug("init():  directStatus.getIsTwentyTodayError() = " + directStatus.getIsTwentyTodayError());
			logger.debug("init():  directStatus.getIsSrvUnavailableError() = " + directStatus.getIsSrvUnavailableError());
			logger.debug("init():  directStatus.getIsSuccess() = " + directStatus.getIsSuccess());
			logger.debug("init():  status.getIsRefreshCalled() = " + status.getIsRefreshCalled());
		}
		
		findUser();
		resetDirectStatusBean();
		
		if(!FacesContext.getCurrentInstance().isPostback()){
			if (logger.isDebugEnabled()) {
				logger.debug("init():  FacesContext.getCurrentInstance().isPostback() = false") ;
				logger.debug("init():  resetting messages") ;
			}
			resetMessages();
		}
		
		if(!status.getIsRefreshCalled()){
			if (logger.isDebugEnabled()) {
				logger.debug("init():  status.getIsRefreshCalled() = false") ;
			}
			lookupCCDReportStatus(true);
		}else{
			if (logger.isDebugEnabled()) {
				logger.debug("init():  status.getIsRefreshCalled() = true") ;
				logger.debug("init():  calling status.setIsRefreshCalled(false)") ;
			}
			status.setIsRefreshCalled(false); //must reset this flag in the bean to allow the ccdosservice to be called the next time the page is visited
		}
	}
	
	public void initSendHS(ComponentSystemEvent event) {
		findUser();
		
		if (logger.isDebugEnabled()) {
			logger.debug("initSendHS():  directStatus.getIsTwiceTodayError() = " + directStatus.getIsTwiceTodayError()) ;
			logger.debug("initSendHS():  directStatus.getIsTwentyTodayError() = " + directStatus.getIsTwentyTodayError());
			logger.debug("initSendHS():  status.getIsRefreshCalled() = " + status.getIsRefreshCalled());
		}

		if(!FacesContext.getCurrentInstance().isPostback()){
			if (logger.isDebugEnabled()) {
				logger.debug("initSendHS(): Not a postback") ;
			}

			resetMessages();
		}
		sendHealthSummaryForm.initialize();
		
	}
	
	public void initPreviewHS(ComponentSystemEvent event) {
		findUser();
		try {
			activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VIEW_MY_VA_HEALTH_SUMMARY_PDF, ""));
		} catch (MHVException e) {
			logger.error(e);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
		}
		
	}
	
	public void back() {
		view.setViewMode(ViewMode.MV_SELECT_REPORT);
	}
	
	protected void resetDirectStatusBean(){
		if (logger.isDebugEnabled()) {
			logger.debug("resetDirectStatusBean():  resetting all values in the direct status bean") ;
		}
		directStatus.setIsSuccess(false);
		directStatus.setIsDisclaimerError(false);
		directStatus.setIsEmailFormatError(false);
		directStatus.setIsEmailRequiredError(false);
		directStatus.setIsEmailMatchError(false);
		directStatus.setIsTwiceTodayError(false);
		directStatus.setIsSrvUnavailableError(false);
		directStatus.setIsInvalidProviderError(false);
		directStatus.setIsTwentyTodayError(false);
	}		

	public void checkCCDUpdatingStatus() {
		if(logger.isDebugEnabled()) {
			logger.debug("Refreshing Health Summary Download Results");
		}
		status.setIsRefreshCalled(true);
		lookupCCDReportStatus(false);
	}
	
	public SendHealthSummaryFormBean getSendHealthSummaryForm() {
		return sendHealthSummaryForm;
	}
	
	protected void lookupCCDReportStatus(boolean recordDownloadRequestedAALEntry) {
		List<DocStatus> docStatuses = null;
		List<HealthSummaryDTO> healthSummariesList = new ArrayList<HealthSummaryDTO>();
		
		GregorianCalendar gcal = new GregorianCalendar();
	    XMLGregorianCalendar dateGenerated;
		try {
			dateGenerated = DatatypeFactory.newInstance()
			        .newXMLGregorianCalendar(gcal);
		} catch (DatatypeConfigurationException e2) {
			logger.debug("Date CCD/CCDA retrieval from adapter request was generated :"+e2.toString());
		}

		String returnedStatus = null;
		boolean ccdStatusComplete = true;
		boolean ccdStatusError = false;
		boolean foundFirstCcdStatusComplete = false;  
		
		healthSummariesList.clear();
		status.setccdRequestDateForVADirectSend(null);
		status.setCcdRequestDateForPreview(null);
		status.setIsServiceError(false);
		status.setIsDataError(false);
		status.setIsNothingToShow(false);
		status.setIsUpdating(false);
		status.setIsComplete(false);
		try {
			
			if(this.getIsVACCDDirectFieldTestUser())
				docStatuses = bbRepositoryfactory.getRepositoryWSPort().getStatus(getPatientICNFromSession(), getLastName(), "CCDA");
			else
				docStatuses = bbRepositoryfactory.getRepositoryWSPort().getStatus(getPatientICNFromSession(), getLastName(), "c32");

			
			
			for (DocStatus docStatus : docStatuses) {
				
				dateGenerated = docStatus.getDateGenerated();

				returnedStatus = docStatus.getStatus();
				if(!returnedStatus.equals("COMPLETE") && !returnedStatus.contains("ERROR")){
					ccdStatusComplete = false;
					ccdStatusError = false;
					status.setIsServiceError(false); 
					
				}
				if(returnedStatus.contains("ERROR")){
					status.setIsDataError(true); 
					ccdStatusError = true;
				}
				if(returnedStatus.equals("COMPLETE") && !foundFirstCcdStatusComplete){
					foundFirstCcdStatusComplete = true;
					status.setccdRequestDateForVADirectSend(getDateGeneratedTs(dateGenerated));
					status.setCcdRequestDateForPreview(getDateGeneratedTs(docStatus.getDateGenerated()));
				}
				
				HealthSummaryDTO healthSum= new HealthSummaryDTO();
				healthSum.setFileContents("VA CCD");
				healthSum.setFilename(healthSum.getDisplayFileName(dateGenerated, getLastName()));
				healthSum.setRequestDate(healthSum.getDisplayRequestDate(dateGenerated));
				healthSum.setStatus(healthSum.getShowStatus(returnedStatus));
				healthSum.setDateGeneratedTs(getDateGeneratedTs(docStatus.getDateGenerated()));
				
				healthSummariesList.add(healthSum);
				
			}						
			
			if(docStatuses != null && !ccdStatusError){
				if(!ccdStatusComplete){
					status.setIsUpdating(true);
				}else{
					status.setIsUpdating(false);
					status.setIsComplete(true);
				}
			}

			if(!ccdStatusError){
				healthSummaries.setHealthSummaries(healthSummariesList);
			}else{
				healthSummariesList.clear();
				healthSummaries.setHealthSummaries(healthSummariesList);
			}
			if(recordDownloadRequestedAALEntry)
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VA_HEALTH_SUMMARY_DOWNLOAD_REQUESTED, ""));
		} catch (MHVException e) {
			status.setIsServiceError(true);
			logger.debug("#?#?#?Exception:"+e.toString());
			if(recordDownloadRequestedAALEntry)
				try {
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VA_HEALTH_SUMMARY_DOWNLOAD_REQUESTED, ""));
				} catch (MHVException e1) {
					logger.error("#?#?#?Exception:"+e.toString());
				}
				
				//Auditor.auditDownloadDataRequestEvent(getCurrentUserId(),ActivityActorTypeEnumeration.SELF,false, ActivityActionTypeEnumeration.VA_HEALTH_SUMMARY_DOWNLOAD_REQUESTED);
		} catch (Exception e){
			status.setIsServiceError(true);
			logger.debug("#?#?#?Exception:"+e.toString());
			e.printStackTrace();
		}

	}
	
	public String getDateGeneratedTs(Calendar dateGenerated) {
        String displayDownloadValue = "";
		Date requestDate = null;
		if(dateGenerated!=null)
			requestDate = dateGenerated.getTime();
		if(requestDate != null) {
			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
			displayDownloadValue = formatter.format(requestDate);
			return displayDownloadValue.toString();
		}
		else
			return "";
    }
	
	public void sendCCDA()
	{
		findUser();
		resetDirectStatusBean();
		
		if (logger.isInfoEnabled()) {
			logger.info("User " + getUserName() + " having USER_PROFILE_ID " +getUserProfileId() + " Requested to share the CCD");
		}
		// send form validation routines
		if(!sendHealthSummaryForm.isHsDisclaimerCheckbox()){
			directStatus.setIsDisclaimerError(true);
		}else if((sendHealthSummaryForm.getHsDirectAddress()==null ||
					(sendHealthSummaryForm.getHsDirectAddress()!=null && sendHealthSummaryForm.getHsDirectAddress().length()<1))
					|| (sendHealthSummaryForm.getHsConfirmDirectAddress()==null ||
					(sendHealthSummaryForm.getHsConfirmDirectAddress()!=null && sendHealthSummaryForm.getHsConfirmDirectAddress().length()<1))){
			directStatus.setIsEmailRequiredError(true);
		}else if(sendHealthSummaryForm.getHsDirectAddress()!=null && sendHealthSummaryForm.getHsConfirmDirectAddress()!=null
				    && !sendHealthSummaryForm.getHsDirectAddress().toString().equals(sendHealthSummaryForm.getHsConfirmDirectAddress().toString())){
			directStatus.setIsEmailMatchError(true);
		}else if(sendHealthSummaryForm.getHsDirectAddress()!=null && sendHealthSummaryForm.getHsConfirmDirectAddress()!=null
				    && !isValidEmailAddress(sendHealthSummaryForm.getHsDirectAddress())){
			directStatus.setIsEmailFormatError(true);
		}else if(hasSentTwoToday(sendHealthSummaryForm.getHsDirectAddress())){
			directStatus.setIsTwiceTodayError(true);
		}else if(hasSentTwentyToday()){
			directStatus.setIsTwentyTodayError(true);
		}else{
			try {
				
				String directResult = sendCCDViaDirect(sendHealthSummaryForm.getHsDirectAddress(), status.getccdRequestDateForVADirectSend());
			
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), true, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.ACCEPTED_CONDITIONS_OF_USE, "Conditions of Use were read and accepted"));
				
				if(directResult.equals(CCD_VIA_DIRECT_SUCCESS)){
					directStatus.setIsSuccess(true);
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), true, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.REQUEST_SUBMITTED, "Request to send VA Health Summary to " + sendHealthSummaryForm.getHsDirectAddress() + " submitted"));
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSystem(getUserProfileId(), true, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + sendHealthSummaryForm.getHsDirectAddress() + " completed"));
				} else if(directResult.equals(CCD_VIA_DIRECT_INVALID_DIRECT_ADDR)){
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSystem(getUserProfileId(), false, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + sendHealthSummaryForm.getHsDirectAddress() + " completed"));
					directStatus.setIsInvalidProviderError(true);
				} else if(directResult.equals(CCD_VIA_DIRECT_FAIL)){
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), true, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.REQUEST_SUBMITTED, "Request to send VA Health Summary to " + sendHealthSummaryForm.getHsDirectAddress() + " submitted"));
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSystem(getUserProfileId(), false, ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + sendHealthSummaryForm.getHsDirectAddress() + " completed"));
					directStatus.setIsSrvUnavailableError(true);
				}
			}
			catch (MHVException e) {
				logger.error(e);
			}
			
		}
	}
	
	protected String sendCCDViaDirect(String directAddress, String requestDate){

		//here is where we want to call the Download Servlet to return first the xml and then the
		//pdf versions of the ccd to be attached

		//the ccd.xsl stylesheet is located here:
		///mhv-portal-web/ShowBinary/BEA Repository/personal_info/downloadCCDData/CCD.xsl
		String sendResult = "";
		C32Document ccda = null;
    	
		try{
			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm");
			Date date = null;
			XMLGregorianCalendar calendaredRequestDate = DatatypeFactory.newInstance().newXMLGregorianCalendar();
			try {
				date = formatter.parse(requestDate);
				GregorianCalendar c = new GregorianCalendar();
				c.setTime(date);
				calendaredRequestDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
			} catch (ParseException e) {
				logger.error(e.getStackTrace());
			}
			
			Calendar requestDateCal = Calendar.getInstance();
	    	if(requestDate!=null){
				date = null;
				try {
					date = formatter.parse(requestDate);
				} catch (ParseException e) {
					logger.error(e.getLocalizedMessage());
				}
				requestDateCal.setTime(date);
			}
			SimpleDateFormat sdformatter = new SimpleDateFormat("'_'yyyyMMdd'_'HHmm");
			Timestamp t = null;
			t = new Timestamp(requestDateCal.getTime().getTime());
			StringBuffer hhFileName = new StringBuffer();
			hhFileName.append("mhv_VA_CCD_");
			hhFileName.append(getLastName());
			hhFileName.append(sdformatter.format(t));
			StringBuffer hhFileName1 = new StringBuffer(hhFileName.toString());
			String xmlFilename = hhFileName1.append(".xml").toString();
			String pdfFilename = hhFileName.append(".pdf").toString();

			ccda = bbRepositoryfactory.getRepositoryWSPort().getDocument(calendaredRequestDate, getIcn());
			byte[] xml = decode(ccda.getDocument());
						
			String xslFileName = "";
			
			xslFileName = "xsl/cda.xsl";
			
			Templates templates = (Templates)CACHE.get(xslFileName);
	        if (templates == null)
	        {
	            TransformerFactory tfactory =
	                       TransformerFactory.newInstance();
	            
	            ClassLoader cl = this.getClass().getClassLoader();
	            String systemID = xslFileName;
	            InputStream in = cl.getResourceAsStream(systemID);
	            URL url = cl.getResource(systemID);
	            Source xslSource = new StreamSource(in);
	            xslSource.setSystemId(url.toExternalForm());

	            templates = tfactory.newTemplates
	                        (xslSource);

	            CACHE.put(xslFileName, templates);
	        }
	        transformer  = templates.newTransformer();
			
			ByteArrayInputStream stream = new ByteArrayInputStream(xml);
			Source source = new StreamSource((InputStream) stream);

			ByteArrayOutputStream os = new ByteArrayOutputStream();
			//Result result = new StreamResult(os);
			try{
				transformer.transform(source, new StreamResult(os));
			}catch(Exception e){
				e.printStackTrace();
			}

			PdfXHTMLWrapper p = new PdfXHTMLWrapper();
			byte pdf[] = p.makePdfFromXhtml(getFirstName()+" "+getLastName(), os.toString());
			
			Map<String, byte[]> attachments = new HashMap<String, byte[]>();
			attachments.put(xmlFilename, xml);
			attachments.put(pdfFilename, pdf);
			sendResult = send(directMessageFrom, directAddress, "", null, null, directMessageSubject, directMessageBody, attachments);

		} catch (RuntimeException | TransformerException | IOException | DatatypeConfigurationException | com.itextpdf.text.DocumentException e){
			return CCD_VIA_DIRECT_FAIL;
		}

		return sendResult;

	}

	public static boolean isValidEmailAddress(String email) {
	   boolean result = true;
	   try {
	      InternetAddress emailAddr = new InternetAddress(email);
	      emailAddr.validate();
	   } catch (AddressException ex) {
	      result = false;
	   }
	   return result;
	}

	public boolean hasSentTwoToday(String directAddr) {
		if (logger.isDebugEnabled()) {
			logger.debug("hasSentTwoToday() was called") ;
			logger.debug("hasSentTwoToday(): directPerProviderPerDay = " + directPerProviderPerDay) ;
			logger.debug("hasSentTwoToday(): directAddr = " + directAddr) ;
		}
		
		boolean hasSentTwoToday = false;

		try{
		List<DirectMessageDTO> directMesages = directMessageServiceProxy.getDirectMessagesSentTodayByUserProfileId(getUserProfileId());

		if (logger.isDebugEnabled()) {
			logger.debug("hasSentTwoToday(): number of messages sent to '" + directAddr + "' today = " + ( directMesages != null ? directMesages.size() : "directMesages list = null")) ;
		}

		if ((directMesages != null)) {
			int count = 0;
		    for (DirectMessageDTO activity : directMesages) {
	    		if (logger.isDebugEnabled()) {
	    			logger.debug("hasSentTwoToday(): sentToEmailAddress = " + activity.getSentToEmailAddress()) ;
	    			logger.debug("hasSentTwoToday(): count = " + count) ;
	    		}
	    		
		        if (activity.getSentToEmailAddress() != null && directAddr != null && directAddr.equals(activity.getSentToEmailAddress())) {
		    		if (logger.isDebugEnabled()) {
		    			logger.debug("hasSentTwoToday(): sentToEmailAddress = directAddr:  Increase count from " + count + " to " + (count+1));
		    		}
		        	count++;
		        }
		        if (count >= Integer.parseInt(directPerProviderPerDay)) {
		    		if (logger.isDebugEnabled()) {
		    			logger.debug("hasSentTwoToday(): directPerProviderPerDay limit has been reached:  count = " + count);
		    		}
		        	hasSentTwoToday = true;
		        	break;
		        }
		    }
		}
		
		}catch(Exception e){
			logger.debug("######:"+e.getLocalizedMessage());	
		}
	    return hasSentTwoToday;
	}

	public boolean hasSentTwentyToday() {
		boolean hasSentTwentyToday = false;

		try{
		List<DirectMessageDTO> directMesages = directMessageServiceProxy.getDirectMessagesSentTodayByUserProfileId( getUserProfileId() );

		if ((directMesages != null)) {
			int count = 0;
		    for (Object a : directMesages) {
		    	DirectMessageDTO activity = (DirectMessageDTO) a;
				if (activity.getSentToEmailAddress()!=null)
		        	count++;
		        if(count > Integer.parseInt(directPerDay) - 1){
		        	count = 0;
		        	hasSentTwentyToday = true;
		        	break;
		        }
		    }
		}
		}catch(Exception e){
			logger.debug("######:"+e.getLocalizedMessage());	
		}
	   return hasSentTwentyToday;
		
	}
	
	private String send(String sender, String to, String cc, String mailtype, String priority, String subject, String body, Map<String, byte[]> files) {
        String rtc = CCD_VIA_DIRECT_FAIL;
        HttpURLConnection connDirect = null;

        try {
            URL urlDirect = new URL(directSendurl);

            connDirect = (HttpURLConnection)urlDirect.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "POST\n" + dstr + "\n" + directSendpath;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec((directPrivatekey).getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + (directPublickey) + ":" + encsha;
            connDirect.setRequestProperty("Authorization", auth);
            connDirect.setRequestProperty("Date", dstr);
            String charset = "UTF-8";
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            String lineEnd = "\r\n";
            String twoHyphens = "--";

            // Allow Inputs
            connDirect.setDoInput(true);

            // Allow Outputs
            connDirect.setDoOutput(true);

            // Don't use a cached copy.
            connDirect.setUseCaches(false);

            // Use a post method.
            connDirect.setRequestMethod("POST");

            connDirect.setRequestProperty("Connection", "Keep-Alive");
            connDirect.setRequestProperty("Accept-Charset", charset);
            connDirect.setRequestProperty("Charset", charset);
            connDirect.setRequestProperty("ENCTYPE", "multipart/form-data");
            connDirect.setRequestProperty("Cache-Control", "no-cache");
            connDirect.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary); //boundary was misspelled here as boundry

            String newBody = "";
            DataOutputStream ds = new DataOutputStream(connDirect.getOutputStream());
            if(body!=null){
            	String firstLast = getFirstName() + " " + getLastName();
            	newBody = body.replace("[vvv]", firstLast);
            }

       		//put plain text post data into an array so we can build the raw request
            Map<String, String> post_fields = new HashMap<String, String>();
            post_fields.put("sender",sender);
            post_fields.put("to",to);
            if (cc != null && cc.length() > 0) {post_fields.put("cc",cc); }
            if (subject != null && subject.length() > 0) { post_fields.put("subject",subject); }
            if (newBody != null && newBody.length() > 0) { post_fields.put("body",newBody); }
            if (mailtype != null && mailtype.length() > 0) { post_fields.put("mailtype",mailtype); }
            if (priority != null && priority.length() > 0) { post_fields.put("priority",priority); }

          //setRequestProperty seems to set headers for the overall request, but the POST body comes after those
    		//so loop through normal POST fields and add to raw request body instead
    		for(Map.Entry<String, String> entry : post_fields.entrySet()) {
    			ds.writeBytes(twoHyphens + boundary + lineEnd);
    			ds.writeBytes("Content-Disposition: form-data; name=\""+entry.getKey()+"\"" + lineEnd + lineEnd + entry.getValue() + lineEnd);
    		}
    		//add last boundary for normal fields
    		ds.writeBytes(twoHyphens + boundary + lineEnd);

    		//if you have more than one file loop through them here
    		int i = 1;
    		for(String filename: files.keySet()) {
    			 ds.writeBytes("Content-Disposition: form-data; name=\"files"+i+"\";filename=\"" + filename +"\"" + lineEnd);
    			//added generic content type for the file and specified transfer encoding, this appears to be necessary for files
    			ds.writeBytes("Content-Type: application/octet-stream" + lineEnd);
    			ds.writeBytes("Content-Transfer-Encoding: binary" + lineEnd);
    			ds.writeBytes(lineEnd);
    			ds.write(files.get(filename));
    			if(i < files.size()) { ds.writeBytes(twoHyphens + boundary + lineEnd); } //if not last file, write a (non-final) boundary
    			i++;
    		}
    		//final boundary for the POST request (hyphens before and after)
    		ds.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);

    		ds.flush();
    		ds.close();


            if (connDirect.getResponseCode() == 200 ) {
            	BufferedReader br = new BufferedReader(new InputStreamReader((connDirect.getInputStream())));
                String output;
                String resp = "";
                while ((output = br.readLine()) != null) {
                    resp += output;
                }

                String messageId = "";
                String messageStatus = "";
                if(resp.indexOf("\"id")>0){
                	messageId = resp.substring(resp.indexOf("\"id\":\"")+6, resp.indexOf("\",\"message"));
                	messageStatus = resp.substring(resp.indexOf("\"message\":\"")+11, resp.indexOf(".\"}"));

                	DirectMessageDTO directMessageRecord = new DirectMessageDTO();
                	directMessageRecord.setMessageId(messageId);
                	directMessageRecord.setSentToEmailAddress(to);
                	directMessageRecord.setUserProfileId(this.getUserProfileId());
                	directMessageRecord.setDirectMessageStatus(messageStatus);
                	Calendar calendar = Calendar.getInstance();
                    java.sql.Timestamp ourJavaTimestampObject = new java.sql.Timestamp(calendar.getTime().getTime());
                    directMessageRecord.setCreatedDate(ourJavaTimestampObject);
                    directMessageServiceProxy.saveDirectMessage(directMessageRecord);
                }
    			rtc = CCD_VIA_DIRECT_SUCCESS;
            }else if(connDirect.getResponseCode() == 400){
				
            	rtc = CCD_VIA_DIRECT_INVALID_DIRECT_ADDR;
            }else{
            	throw new RuntimeException("\nFailed : HTTP error code : " + connDirect.getResponseCode() + "\nHTTP response : " + connDirect.getResponseMessage());
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
//        } catch (MHVException e) {
//			logger.error(e);
		} finally {
            if (connDirect != null) {
            	connDirect.disconnect();
            }
        }
        return rtc;
    }
    
    public static byte[] decode(String encoded) {
		byte[] decoded = org.apache.commons.codec.binary.Base64.decodeBase64(encoded.getBytes());
		return decoded;
	}
	
	

}
