package gov.va.med.mhv.bluebutton.web.controller;

import gov.va.med.mhv.bluebutton.web.bean.FieldTestBean;
import gov.va.med.mhv.common.api.enumeration.FieldTestEnum;
import gov.va.med.mhv.common.api.enumeration.UserTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;


public class AbstractHealthSummaryController  implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2251953933054498182L;
	private static Logger logger = LogManager.getLogger(AbstractHealthSummaryController.class);
	private static final String USERPROFILE_DTO_KEY = "LIFERAY_SHARED_userprofiledto";
	private static final String USER_ROLE_KEY = "LIFERAY_SHARED_accountType";
	private static final String PATIENT_ICN_KEY = "LIFERAY_SHARED_patienticn";
	private static final String API_SESSION_TOKEN_KEY = "APISessionToken";
	private String firstName;
	private String lastName;
	private String userName;
	private String icn;
	protected Boolean saveMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteMessage = false;
	protected static final String CONTENT_TYPE="application/json";
	public String shareCCDRequestDate = "";
	
	@Autowired
	private FieldTestBean fieldTest;
	
	@Autowired
	private ObjectMapper mapper;
	
	@Resource
	private UserMgmtService userMgmtServiceProxy;
	
	Boolean isBasicUser = null;
	Boolean isAdvancedUser = null;
	Boolean isPremiumUser = null;
	Boolean isVACCDDirectFieldTestUser = null;
	String ccdType = "";
	Boolean isBBMIFieldTestUser = null;
	
	public void findUser() {
		PortletRequest request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user=null;
        try{
        	user = PortalUtil.getUser(request);
        
			if(user != null){
				setFirstName(user.getFirstName());
				setLastName(user.getLastName());
				setUserName(user.getScreenName());
				setIcn(getPatientICNFromSession());
			}
        }catch(Exception e){
        	logger.error(e.getStackTrace());
        }
	}
	
	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid",
				PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
	
	protected void resetMessages(){
		saveMessage = false;
		saveAndAddMessage = false;
		deleteMessage = false;
	}		

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}
	
	public String getShareCCDRequestDate() {
		return shareCCDRequestDate;
	}

	public void setShareCCDRequestDate(String shareCCDRequestDate) {
		this.shareCCDRequestDate = shareCCDRequestDate;
	}
	
	
	
	public Boolean getIsBasicUser() throws MHVException {
		if (isBasicUser == null) {
			isBasicUser = new Boolean(UserTypeEnum.isBasic(getUserRoleFromSession()));
		}
		return isBasicUser;
	}
	
	public Boolean getIsAdvancedUser() throws MHVException {
		if (isAdvancedUser == null) {
			isAdvancedUser = new Boolean(UserTypeEnum.isAdvanced(getUserRoleFromSession()));
		}
		return isAdvancedUser;
	}

	public Boolean getIsPremiumUser() throws MHVException {
		if (isPremiumUser == null) {
			isPremiumUser = new Boolean(UserTypeEnum.isPremium(getUserRoleFromSession()));
		}
		return isPremiumUser;
	}
	
	public Boolean getIsVACCDDirectFieldTestUser() {
		if (isVACCDDirectFieldTestUser == null) {
			isVACCDDirectFieldTestUser = new Boolean(testFieldTestGroup(FieldTestEnum.VACCDDIRECT_FIELD_TESTER));
		}
		return isVACCDDirectFieldTestUser;
	}
	
	public String getCcdType() {
		if(getIsVACCDDirectFieldTestUser())
			return "CCDA";
		else
			return "C32";
	}
	
	public Boolean getIsBBMIFieldTestUser() { 
		if (isBBMIFieldTestUser == null) {
			isBBMIFieldTestUser = new Boolean(testFieldTestGroup(FieldTestEnum.BBMI_FIELD_TESTER));
		}
		return isBBMIFieldTestUser;
	}
	
	public Boolean testFieldTestGroup( FieldTestEnum fte) {
		Boolean result = false;
		
		if( fte.getNational() ) {
			return true;
		} else if( fieldTest.getInitialized() ) {
			return fieldTest.getFieldTestList().contains(fte);
		} else {
			try {
				List<FieldTestDTO> dtos = userMgmtServiceProxy.getFieldTestGroupsByUserName(getUserProfileDTOFromSession().getUserName());
				
				List<String> names = FieldTestEnum.toNameList();

				for( FieldTestDTO d: dtos) {
					
					if( d.getName().equals(fte.getName())) {
							result = true;
					}
					//MERGE ALL THE NATIONAL STATUS FOR KNOWN FEATURES
					//AND LOCAL SESSION INSTANCE CONTAINING ALL THIS USERS FIELD TEST GROUPS
					if( names.contains(d.getName()) ) {
						FieldTestEnum e = FieldTestEnum.valueOfByName(d.getName());
						if( d.getIsNational() && !e.getNational() ) {
							e.setNational(true);
						}
						fieldTest.getFieldTestList().add(e);
						if(logger.isDebugEnabled()) {
							logger.debug("Added feature "+ d.getName() +" for role: '" + d.getRole() +"' "+ (e.getNational()?"(National)":"(Field Tester)"));
						}
					}
					
				}
				//Prevents the fieldTest list from being loaded more than once per session
				fieldTest.setInitialized(true);
			} catch (MHVException e) {
				if(logger.isErrorEnabled()) {
					logger.error(e);
				}
			}
		}
		return result;
	}
	
	protected UserProfileDTO getUserProfileDTOFromSession() throws MHVException {
		UserProfileDTO userProfile;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			
			String patientStr =  (String)session.getAttribute(USERPROFILE_DTO_KEY, PortletSession.APPLICATION_SCOPE);
			userProfile = mapper.readValue(patientStr, UserProfileDTO.class);
			
		} catch(Exception e) {
			throw new MHVException("Unable to get UserProfileDTO from session");
		}
		return userProfile;
	}
	
	protected UserTypeEnum getUserRoleFromSession() throws MHVException {
		UserTypeEnum userRole;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			
			String userRoleStr =  (String)session.getAttribute(USER_ROLE_KEY, PortletSession.APPLICATION_SCOPE);
			userRole = UserTypeEnum.valueOfByRole(userRoleStr);
			
		} catch(Exception e) {
			throw new MHVException("Unable to get user role from session");
		}
		return userRole;
	}
	
	protected String getPatientICNFromSession() throws MHVException {
		String patientICN;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			patientICN = (String)session.getAttribute(PATIENT_ICN_KEY, PortletSession.APPLICATION_SCOPE);
		} catch(Exception e) {
			throw new MHVException("Unable to get Patient ICN from session");
		}
		return patientICN;
	}

	public String getAPIToken() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String token = (String)session.getAttribute(API_SESSION_TOKEN_KEY);
		
		return token;
	}
	
	public String getDateGeneratedTs(XMLGregorianCalendar dateGenerated) {
        String displayDownloadValue = "";
		DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
		
		if(dateGenerated !=null){
			Calendar calendar = dateGenerated.toGregorianCalendar();
			displayDownloadValue = formatter.format(calendar.getTime());
			return displayDownloadValue;
		}
		
		else
			return "";
    }
}
