package gov.va.med.mhv.bluebutton.web.bean;

import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportDTO;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class BlueButtonReportBean implements Serializable {

	private static final long serialVersionUID = -4753567075660359376L;
	private static Logger logger = LogManager.getLogger(BlueButtonReportBean.class);

	//01 Feb 2016 @ 1151
	private Date requestDate;
	
	private List<BlueButtonReportDTO> reportList = new ArrayList<BlueButtonReportDTO>();

	public String getRequestDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy @ HHmm");
		return sdf.format(requestDate);
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

	public List<BlueButtonReportDTO> getReportList() {
		return reportList;
	}

	public void setReport(BlueButtonReportDTO txt) {
		this.reportList = new ArrayList<BlueButtonReportDTO>();
		//make 2 entries (PDF and TXT)
		
		BlueButtonReportDTO pdf = new BlueButtonReportDTO();
		pdf.setFilename(replaceLastIndexOf(txt.getFilename(),".txt",".pdf"));
		//PDF is (fileSz*5)+21658L
		pdf.setFilesize((txt.getFilesize()*5)+21658L);
		pdf.setReportId(txt.getReportId());
		
		txt.setType(ReportTypeEnum.TXT);
		pdf.setType(ReportTypeEnum.PDF);
		
		reportList.add(pdf);
		reportList.add(txt);
	}
	
	public static String replaceLastIndexOf(String source, String pattern, String repl) {
		int idx = source.lastIndexOf(pattern);
		return source.subSequence(0, idx)+repl;
	}
}

